/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.autoemul;

import java.util.Comparator;

public class DeviceEntry
implements Comparable<DeviceEntry> {
    private final String entryName;
    private final String entryResolution;
    private String entryStatus;
    public static Comparator<DeviceEntry> DeviceEntryComparator = new Comparator<DeviceEntry>(){

        @Override
        public int compare(DeviceEntry entry1, DeviceEntry entry2) {
            String deviceEntryName1 = entry1.getEntryName().toUpperCase();
            String deviceEntryName2 = entry2.getEntryName().toUpperCase();
            return deviceEntryName1.compareTo(deviceEntryName2);
        }
    };

    private DeviceEntry(Builder builder) {
        this.entryName = builder.entryName;
        this.entryResolution = builder.entryResolution;
        this.entryStatus = builder.entryStatus;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public String getEntryResolution() {
        return this.entryResolution;
    }

    public String getEntryStatus() {
        return this.entryStatus;
    }

    public void setEntryStatus(String entryStatus) {
        this.entryStatus = entryStatus;
    }

    @Override
    public int compareTo(DeviceEntry deviceEntry) {
        if (this == deviceEntry) {
            return 0;
        }
        int comparison = this.entryName.compareTo(deviceEntry.entryName);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.entryResolution.compareTo(deviceEntry.entryResolution);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.entryStatus.compareTo(deviceEntry.entryStatus);
        if (comparison != 0) {
            return comparison;
        }
        return 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.entryName == null ? 0 : this.entryName.hashCode());
        result = 31 * result + (this.entryResolution == null ? 0 : this.entryResolution.hashCode());
        result = 31 * result + (this.entryStatus == null ? 0 : this.entryStatus.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DeviceEntry)) {
            return false;
        }
        DeviceEntry anotherDeviceEntry = (DeviceEntry)object;
        if (!this.entryName.equals(anotherDeviceEntry.entryName)) {
            return false;
        }
        if (!this.entryResolution.equals(anotherDeviceEntry.entryResolution)) {
            return false;
        }
        return this.entryStatus.equals(anotherDeviceEntry.entryStatus);
    }

    /* synthetic */ DeviceEntry(Builder builder, DeviceEntry deviceEntry) {
        this(builder);
    }

    public static class Builder {
        private final String entryName;
        private String entryResolution = "0";
        private String entryStatus = "OFFLINE";

        public Builder(String entryName) {
            this.entryName = entryName;
        }

        public Builder entryResolution(String val) {
            this.entryResolution = val;
            return this;
        }

        public Builder entryStatus(String val) {
            this.entryStatus = val;
            return this;
        }

        public DeviceEntry build() {
            return new DeviceEntry(this, null);
        }
    }

    public static enum EntryDeviceType {
        EMULATOR,
        REMOTE,
        REALDEVICE;


        public String toString() {
            return this.name();
        }
    }
}

