/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.constants.IRestUIConstants;
import org.tizen.common.rest.model.RepositoryManager;
import org.tizen.common.rest.model.schema.AbstractWadlModel;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.IRestUiModel;
import org.tizen.common.rest.model.schema.IWadlModel;
import org.tizen.common.rest.model.schema.Method;
import org.tizen.common.rest.model.schema.Param;
import org.tizen.common.rest.model.schema.Representation;
import org.tizen.common.rest.model.schema.Request;
import org.tizen.common.rest.model.schema.Resource;
import org.tizen.common.rest.model.schema.Resources;
import org.tizen.common.rest.ui.RestImageRegistry;
import org.tizen.common.rest.ui.dialogs.RestParamDialog;
import org.tizen.common.rest.ui.dialogs.RestParamEditing;
import org.tizen.common.rest.ui.dialogs.RestParamImageLabelProvider;
import org.tizen.common.rest.ui.dialogs.RestParamLableProvider;
import org.tizen.common.rest.ui.dialogs.RestParamTableSelectionListener;
import org.tizen.common.rest.util.ModelUtil;
import org.tizen.common.util.ImageUtil;
import org.tizen.common.util.StringUtil;

public class RestDialog
extends TitleAreaDialog
implements ModifyListener {
    private static final int SAVE_AND_RUN_ID = 1000;
    private static final String SAVE_AND_RUN_LABEL = "Save and Run";
    protected String title = "";
    protected String desc = "";
    public static int OPEN_NEW_CHILD = 0;
    public static int OPEN_NEW_SERVICE = 1;
    public static int OPEN_MODIFY = 2;
    private int openType = OPEN_NEW_CHILD;
    public static int WIDTH = 670;
    public static int HEIGHT = 550;
    protected int x = 0;
    protected int y = 0;
    public static String[] tableHeader = new String[]{"Parent", "Name", "Value", "Style", "Type", "Required"};
    private int[] width = new int[]{120, 100, 120, 100, 100, 50};
    public String[] apiNames = IRestUIConstants.DEFAULT_METHOD_COMBO_ITEMS;
    public String[] apiContents = new String[]{"application/x-www-form-urlencoded", "multipart/form-data"};
    private static TableViewer viewer;
    private Table table;
    protected IStructuredSelection selection;
    private Section sectionApplication;
    protected Text txtTitle = null;
    private Section sectionResources;
    protected Text txtBase = null;
    protected Text txtAlias = null;
    private Section sectionResource;
    private Text txtPP = null;
    protected Text txtPath = null;
    private boolean needParentPathText = false;
    private Section sectionAPI;
    private Text txtId = null;
    private Text txtDescription = null;
    private Combo comboName = null;
    private Combo comboType = null;
    private FocusListener focusListener;
    private ToolItem itemAdd;
    private ToolItem itemRemove;
    private Section sectionParam;
    private IRestUiModel[] modelsFromTree = new IRestUiModel[4];
    private IRestUiModel[] modelsOnDialog = new IRestUiModel[0];
    private Resource[] parentResource = new Resource[0];
    private Map<Param, Param> paramsPairs = null;
    private List<Param> paramsOnTable = null;
    private boolean toRun = false;
    private static boolean isCreated;

    static {
        isCreated = false;
    }

    public RestDialog(Shell parentShell, IStructuredSelection selection, int openType) {
        super(parentShell);
        this.setShellStyle(65648);
        this.setBlockOnOpen(true);
        this.openType = openType;
        this.selection = selection;
        if (this.openType == OPEN_NEW_CHILD) {
            this.title = RestUIMessages.UI_ADD_CHILD;
            this.desc = RestUIMessages.UI_DESC_ADD_CHILD;
        } else if (this.openType == OPEN_NEW_SERVICE) {
            this.title = RestUIMessages.UI_ADD_SERVICE;
            this.desc = RestUIMessages.UI_DESC_ADD_SERVICE;
            HEIGHT = 450;
        } else if (this.openType == OPEN_MODIFY) {
            this.title = RestUIMessages.UI_MODIFY;
            this.desc = RestUIMessages.UI_DESC_MODIFY;
        }
        Rectangle bounds = parentShell.getBounds();
        this.x = bounds.x + (bounds.width - WIDTH) / 2;
        this.y = bounds.y + (bounds.height - HEIGHT) / 2;
        this.paramsPairs = new HashMap<Param, Param>();
        this.paramsOnTable = new ArrayList<Param>();
        this.setInitialModels();
    }

    protected void setInitialModels() {
        if (this.openType == OPEN_NEW_SERVICE) {
            this.modelsFromTree = new IRestUiModel[0];
        } else if (!this.selection.isEmpty()) {
            Object selected = this.selection.getFirstElement();
            if (selected instanceof Application) {
                this.modelsFromTree[0] = (Application)selected;
            } else if (selected instanceof Resources) {
                this.modelsFromTree[1] = (Resources)selected;
                this.modelsFromTree[0] = ((Resources)this.modelsFromTree[1]).getRoot();
            } else if (selected instanceof Resource) {
                this.modelsFromTree[2] = (Resource)selected;
                this.modelsFromTree[1] = ((Resource)this.modelsFromTree[2]).findOwnerResources();
                this.modelsFromTree[0] = ((Resources)this.modelsFromTree[1]).getRoot();
            } else if (selected instanceof Method) {
                this.modelsFromTree[3] = (Method)selected;
                this.modelsFromTree[2] = (Resource)((Method)selected).getParent();
                this.modelsFromTree[1] = ((Resource)this.modelsFromTree[2]).findOwnerResources();
                this.modelsFromTree[0] = ((Resources)this.modelsFromTree[1]).getRoot();
            }
            Resource resource = (Resource)this.modelsFromTree[2];
            if (resource != null) {
                TreePath fPath = resource.getFullPath();
                ArrayList<Resource> parentRList = new ArrayList<Resource>();
                int i = 0;
                while (i < fPath.getSegmentCount()) {
                    Object obj = fPath.getSegment(i);
                    if (obj instanceof Resource && obj != resource) {
                        parentRList.add((Resource)obj);
                    }
                    ++i;
                }
                this.parentResource = parentRList.toArray(new Resource[0]);
            }
            ArrayList<IRestUiModel> initList = new ArrayList<IRestUiModel>();
            IRestUiModel[] iRestUiModelArray = this.modelsFromTree;
            int n = this.modelsFromTree.length;
            int n2 = 0;
            while (n2 < n) {
                IRestUiModel model = iRestUiModelArray[n2];
                if (model != null) {
                    initList.add(model);
                }
                ++n2;
            }
            this.modelsFromTree = initList.size() > 0 ? initList.toArray(new IRestUiModel[0]) : new IRestUiModel[0];
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setLocation(this.x, this.y);
        newShell.setMinimumSize(WIDTH, HEIGHT);
        newShell.setText(this.title);
        this.focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                ((Text)e.widget).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.widget).clearSelection();
            }
        };
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.openType == OPEN_MODIFY) {
            this.createButton(parent, 1000, SAVE_AND_RUN_LABEL, false);
            this.getButton(1000).setEnabled(this.selection.getFirstElement() instanceof Method);
        }
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okPressed();
            this.toRun = false;
        } else if (1 == buttonId) {
            this.cancelPressed();
            this.toRun = false;
        } else if (1000 == buttonId) {
            this.okPressed();
            this.toRun = true;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.setTitle(this.desc);
        FormToolkit toolkit = new FormToolkit(container.getDisplay());
        ScrolledForm sc = toolkit.createScrolledForm(container);
        sc.setLayout((Layout)new GridLayout(1, false));
        sc.setLayoutData((Object)new GridData(1808));
        sc.setAlwaysShowScrollBars(true);
        Composite composite = sc.getBody();
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.sectionApplication = this.createSection(toolkit, composite, 64, RestUIMessages.UI_LBL_SERVICE, 2);
        this.createServicePart(toolkit, (Composite)this.sectionApplication.getClient());
        this.sectionResources = this.createSection(toolkit, composite, 64, RestUIMessages.UI_LBL_BASEURI, 2);
        this.createBaseURIPart(toolkit, (Composite)this.sectionResources.getClient());
        this.sectionResource = this.createSection(toolkit, composite, 64, RestUIMessages.UI_LBL_PATH, 2);
        this.createPathPart(toolkit, (Composite)this.sectionResource.getClient());
        this.sectionAPI = this.createSection(toolkit, composite, 64, RestUIMessages.UI_LBL_API, 2);
        this.createAPIPart(toolkit, (Composite)this.sectionAPI.getClient());
        this.sectionParam = this.createSection(toolkit, composite, 64, RestUIMessages.UI_LBL_PARAM, 2);
        this.sectionParam.setLayoutData((Object)new GridData(1808));
        this.createParamterPart(toolkit, (Composite)this.sectionParam.getClient());
        if (this.openType != OPEN_NEW_SERVICE) {
            this.setInitialValues();
        }
        viewer.setInput(this.paramsOnTable);
        composite.layout();
        sc.reflow(true);
        this.setExpandAndEdit();
        return container;
    }

    private Section createSection(FormToolkit toolKit, Composite parent, int style, String label, int numColumns) {
        Section sec = toolKit.createSection(parent, 0x102 | style);
        sec.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        sec.setText(label);
        Composite client = toolKit.createComposite((Composite)sec, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        sec.setClient((Control)client);
        return sec;
    }

    protected void createServicePart(FormToolkit toolkit, Composite composite) {
        Composite contentComp = toolkit.createComposite(composite);
        contentComp.setLayout((Layout)new GridLayout(2, false));
        contentComp.setLayoutData((Object)new GridData(1808));
        toolkit.createLabel(contentComp, RestUIMessages.UI_LBL_TITLE);
        this.txtTitle = toolkit.createText(contentComp, "", 2048);
        this.txtTitle.setLayoutData((Object)new GridData(768));
        this.txtTitle.addFocusListener(this.focusListener);
        this.txtTitle.addModifyListener((ModifyListener)this);
    }

    protected void createBaseURIPart(FormToolkit toolkit, Composite composite) {
        Composite contentComp = toolkit.createComposite(composite);
        contentComp.setLayout((Layout)new GridLayout(2, false));
        contentComp.setLayoutData((Object)new GridData(1808));
        toolkit.createLabel(contentComp, String.valueOf(RestUIMessages.UI_LBL_BASEURI) + " :");
        this.txtBase = toolkit.createText(contentComp, "", 2048);
        this.txtBase.setLayoutData((Object)new GridData(768));
        this.txtBase.addFocusListener(this.focusListener);
        this.txtBase.addModifyListener((ModifyListener)this);
        toolkit.createLabel(contentComp, RestUIMessages.UI_LBL_ALIAS);
        this.txtAlias = toolkit.createText(contentComp, "", 2048);
        this.txtAlias.setLayoutData((Object)new GridData(768));
    }

    protected void createPathPart(FormToolkit toolkit, Composite composite) {
        Composite contentComp = toolkit.createComposite(composite);
        contentComp.setLayout((Layout)new GridLayout(2, false));
        contentComp.setLayoutData((Object)new GridData(1808));
        if (this.needParentPathText()) {
            toolkit.createLabel(contentComp, RestUIMessages.UI_LBL_PARENT_PATH);
            this.txtPP = toolkit.createText(contentComp, "", 2048);
            this.txtPP.setLayoutData((Object)new GridData(768));
            this.txtPP.addModifyListener((ModifyListener)this);
        }
        toolkit.createLabel(contentComp, String.valueOf(RestUIMessages.UI_LBL_PATH) + " :");
        Composite comp1 = toolkit.createComposite(contentComp);
        comp1.setLayout((Layout)new GridLayout(3, false));
        comp1.setLayoutData((Object)new GridData(768));
        this.txtPath = toolkit.createText(comp1, "", 2048);
        this.txtPath.setLayoutData((Object)new GridData(768));
        this.txtPath.addFocusListener(this.focusListener);
        this.txtPath.addModifyListener((ModifyListener)this);
        Label label = new Label(comp1, 0);
        label.setText(RestUIMessages.UI_LBL_CONTENT);
        this.comboType = RestDialog.makeCombo(comp1, this.apiContents);
    }

    protected void createAPIPart(FormToolkit toolkit, Composite composite) {
        Composite contentComp = toolkit.createComposite(composite);
        contentComp.setLayout((Layout)new GridLayout(2, false));
        contentComp.setLayoutData((Object)new GridData(1808));
        toolkit.createLabel(contentComp, RestUIMessages.UI_LBL_ID);
        Composite comp1 = toolkit.createComposite(contentComp);
        comp1.setLayout((Layout)new GridLayout(3, false));
        comp1.setLayoutData((Object)new GridData(768));
        this.txtId = toolkit.createText(comp1, "", 2048);
        this.txtId.setLayoutData((Object)new GridData(768));
        this.txtId.addFocusListener(this.focusListener);
        this.txtId.addModifyListener((ModifyListener)this);
        toolkit.createLabel(comp1, RestUIMessages.UI_LBL_METHOD);
        this.comboName = RestDialog.makeCombo(comp1, this.apiNames);
        toolkit.createLabel(contentComp, RestUIMessages.UI_LBL_DESCRIPTION);
        Composite comp2 = toolkit.createComposite(contentComp);
        comp2.setLayout((Layout)new GridLayout(1, false));
        comp2.setLayoutData((Object)new GridData(768));
        this.txtDescription = toolkit.createText(comp2, "", 2048);
        this.txtDescription.setLayoutData((Object)new GridData(768));
    }

    private void createParamterPart(FormToolkit toolkit, Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createButtons(composite);
        this.createTable(composite);
    }

    protected void createTable(Composite composite) {
        viewer = new TableViewer(composite, 68354);
        this.createColumn(this.table);
        this.table = viewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setLayoutData((Object)new GridData(1808));
        RestParamTableSelectionListener listener = new RestParamTableSelectionListener(this, viewer, this.itemRemove);
        this.table.addSelectionListener((SelectionListener)listener);
        viewer.getControl().setLayoutData((Object)new GridData(1808));
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    protected void createColumn(Table table) {
        RestParamLableProvider colLabelProvider = new RestParamLableProvider();
        TableViewerColumn col = null;
        int indexReq = tableHeader.length - 1;
        int i = 0;
        while (i < indexReq) {
            col = RestDialog.createTableViewerColumn(tableHeader[i], this.width[i]);
            col.setLabelProvider((CellLabelProvider)colLabelProvider);
            col.setEditingSupport((EditingSupport)new RestParamEditing(this, viewer, Param.PROPERTY.values()[i]));
            ++i;
        }
        col = RestDialog.createTableViewerColumn(tableHeader[indexReq], this.width[indexReq]);
        col.setLabelProvider((CellLabelProvider)new RestParamImageLabelProvider());
        col.setEditingSupport((EditingSupport)new RestParamEditing(this, viewer, Param.PROPERTY.values()[indexReq]));
    }

    protected void createButtons(Composite composite) {
        Composite comp = new Composite(composite, 0x4000000);
        comp.setLayout((Layout)new GridLayout(1, false));
        comp.setLayoutData((Object)new GridData(768));
        ToolBar tb = new ToolBar(comp, 41943104);
        this.itemAdd = new ToolItem(tb, 8);
        this.itemAdd.setToolTipText(RestUIMessages.UI_ADD_PARAM);
        this.itemAdd.setImage(ImageUtil.getImage((ImageDescriptor)RestImageRegistry.IMG_DESC_PARAM_ADD));
        this.itemAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RestParamDialog paramDialog = new RestParamDialog(viewer.getControl().getShell(), RestDialog.this.setModelsOnDialog());
                if (paramDialog.open() == 0) {
                    RestDialog.this.paramsOnTable.add(paramDialog.getParam());
                    viewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.itemRemove = new ToolItem(tb, 8);
        this.itemRemove.setToolTipText(RestUIMessages.UI_REMOVE_PARAM);
        this.itemRemove.setImage(ImageUtil.getImage((ImageDescriptor)RestImageRegistry.IMG_DESC_PARAM_REMOVE));
        this.itemRemove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                if (!selection.isEmpty()) {
                    for (Param param : selection) {
                        if (RestDialog.this.paramsPairs.containsValue(param)) {
                            Set keys = RestDialog.this.paramsPairs.keySet();
                            for (Param keyP : keys) {
                                Param valueP = (Param)RestDialog.this.paramsPairs.get(keyP);
                                if (valueP == null || !valueP.equals(param)) continue;
                                RestDialog.this.paramsPairs.put(keyP, null);
                                RestDialog.this.paramsOnTable.remove(param);
                            }
                            continue;
                        }
                        RestDialog.this.paramsOnTable.remove(param);
                    }
                    RestDialog.this.itemRemove.setEnabled(false);
                    viewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public static TableViewerColumn createTableViewerColumn(String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    protected static Combo makeCombo(Composite composite, String[] contents) {
        Combo combo = new Combo(composite, 8);
        combo.setItems(contents);
        combo.select(0);
        return combo;
    }

    private void setExpandAndEdit() {
        Object obj = this.selection.getFirstElement();
        boolean[] expandable = new boolean[4];
        boolean[] enable = new boolean[]{true, true, true, true};
        if (this.openType == OPEN_NEW_CHILD) {
            if (obj instanceof Application) {
                expandable[1] = true;
                enable[0] = false;
            }
            if (obj instanceof Resources) {
                expandable[2] = true;
                enable[1] = false;
                enable[0] = false;
            }
            if (obj instanceof Resource) {
                expandable[3] = true;
                expandable[2] = true;
                enable[1] = false;
                enable[0] = false;
            }
        } else if (this.openType == OPEN_NEW_SERVICE) {
            expandable[3] = true;
            expandable[2] = true;
            expandable[1] = true;
            expandable[0] = true;
        } else if (obj instanceof Application) {
            expandable[0] = true;
            enable[3] = false;
            enable[2] = false;
            enable[1] = false;
        } else if (obj instanceof Resources) {
            expandable[1] = true;
            enable[3] = false;
            enable[2] = false;
        } else if (obj instanceof Resource) {
            expandable[2] = true;
            enable[3] = false;
        } else if (obj instanceof Method) {
            expandable[3] = true;
        }
        if (this.openType == OPEN_MODIFY) {
            this.sectionApplication.setEnabled(enable[0]);
            this.sectionResources.setEnabled(enable[1]);
            this.sectionResource.setEnabled(enable[2]);
            this.sectionAPI.setEnabled(enable[3]);
        }
        this.sectionApplication.setExpanded(expandable[0]);
        this.sectionResources.setExpanded(expandable[1]);
        this.sectionResource.setExpanded(expandable[2]);
        this.sectionAPI.setExpanded(expandable[3]);
        this.txtTitle.setEnabled(enable[0]);
        this.txtBase.setEnabled(enable[1]);
        this.txtAlias.setEnabled(enable[1]);
        this.txtPath.setEnabled(enable[2]);
        this.comboType.setEnabled(enable[2]);
        if (this.txtPP != null) {
            this.txtPP.setEnabled(false);
        }
        this.txtId.setEnabled(enable[3]);
        this.txtDescription.setEnabled(enable[3]);
        this.comboName.setEnabled(enable[3]);
        if (expandable[0]) {
            this.txtTitle.setFocus();
        } else if (expandable[1]) {
            this.txtBase.setFocus();
        } else if (expandable[2]) {
            this.txtPath.setFocus();
        } else if (expandable[3]) {
            this.txtId.setFocus();
        }
        this.sectionParam.setExpanded(true);
        IRestUiModel[] parents = this.setModelsOnDialog();
        if (parents.length > 0) {
            this.itemAdd.setEnabled(true);
        } else {
            this.itemAdd.setEnabled(false);
        }
        this.itemRemove.setEnabled(false);
    }

    protected void setInitialValues() {
        int cnt;
        if (!this.selection.isEmpty() && (cnt = this.modelsFromTree.length) > 0) {
            IRestUiModel model = this.modelsFromTree[cnt - 1];
            switch (cnt) {
                case 4: {
                    this.setAPIValues((Method)this.modelsFromTree[3]);
                }
                case 3: {
                    this.setRValues((Resource)this.modelsFromTree[2]);
                }
                case 2: {
                    this.setRSValues((Resources)this.modelsFromTree[1]);
                }
                case 1: {
                    this.setAppValues((Application)this.modelsFromTree[0]);
                }
            }
            this.setParamValues(model);
        }
    }

    private void setAppValues(Application application) {
        if (application != null) {
            this.txtTitle.setText(RepositoryManager.getInstance().extractTitle(application));
        }
    }

    private void setRSValues(Resources resources) {
        if (resources != null) {
            this.txtBase.setText(resources.getBase());
            String alias = resources.getTitle();
            if (!StringUtil.isEmpty((CharSequence)alias)) {
                this.txtAlias.setText(alias);
            }
        }
    }

    private void setRValues(Resource resource) {
        if (resource != null) {
            String pp = "";
            if (this.openType == OPEN_NEW_CHILD) {
                pp = this.getParentPath(resource);
                this.txtPP.setText(pp.isEmpty() ? resource.getPath() : String.valueOf(pp) + "/" + resource.getPath());
            } else {
                if (this.needParentPathText) {
                    pp = this.getParentPath(resource);
                    this.txtPP.setText(pp);
                }
                this.txtPath.setText(resource.getPath());
                this.setComboValues(this.comboType, resource.getQueryType(), this.apiContents);
            }
        }
    }

    private void setAPIValues(Method method) {
        if (method != null) {
            method = ModelUtil.findReferences(method);
            String id = method.getId();
            String name = method.getName();
            String description = method.getDescription();
            this.txtId.setText(StringUtil.isEmpty((CharSequence)id) ? "" : id);
            this.txtDescription.setText(StringUtil.isEmpty((CharSequence)description) ? "" : description);
            this.setComboValues(this.comboName, name, this.apiNames);
        }
    }

    private void setParamValues(IWadlModel model) {
        List<IWadlModel> list;
        if (model instanceof Application) {
            list = ((Application)model).getChildren();
        } else if (model instanceof Resources) {
            this.setParamValues(model.getParent());
            list = ((Resources)model).getChildren();
        } else if (model instanceof Resource) {
            this.setParamValues(model.getParent());
            list = ((Resource)model).getChildren();
        } else if (model instanceof Method) {
            this.setParamValues(model.getParent());
            Method method = ModelUtil.findReferences((Method)model);
            list = method.getChildren();
        } else {
            return;
        }
        for (IWadlModel m : list) {
            if (m instanceof Request) {
                Request request = (Request)m;
                for (Param r : request.getParam()) {
                    this.addParamItem(model, r);
                }
                List<Representation> rList = request.getRepresentation();
                for (Representation r : rList) {
                    if (!"multipart/form-data".equals(r.getMediaType())) continue;
                    for (Param p : r.getParam()) {
                        this.addParamItem(model, p);
                    }
                }
            }
            if (!(m instanceof Param)) continue;
            this.addParamItem(model, (Param)m);
        }
        this.table.redraw();
    }

    private void addParamItem(IWadlModel parent, Param p) {
        Param param = new Param(p.getName(), p.getDefault(), p.getStyle(), p.getType(), p.isRequired());
        param.setParent(parent);
        TableItem item = new TableItem(this.table, 0);
        item.setData((Object)param);
        this.paramsPairs.put(p, param);
        this.paramsOnTable.add(param);
    }

    private String getParentPath(Resource r) {
        String parentPath = "";
        String path = "";
        Resource[] resourceArray = this.parentResource;
        int n = this.parentResource.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            path = resource.getPath();
            if (path.startsWith("/")) {
                path = StringUtil.removeStart((String)path, (String)"/");
            }
            if (path.endsWith("/")) {
                path = StringUtil.removeEnd((String)path, (String)"/");
            }
            parentPath = String.valueOf(parentPath) + "/" + path;
            ++n2;
        }
        return parentPath;
    }

    private void setComboValues(Combo combo, String value, String[] arr) {
        if (value != null) {
            int index = 0;
            int i = 0;
            while (i < arr.length) {
                if (value.equals(arr[i])) {
                    index = i;
                    break;
                }
                ++i;
            }
            combo.select(index);
        }
    }

    private boolean needParentPathText() {
        if (this.openType == OPEN_NEW_CHILD) {
            if (this.modelsFromTree.length > 2) {
                this.needParentPathText = true;
            }
        } else if (this.openType == OPEN_MODIFY && this.parentResource.length > 0) {
            this.needParentPathText = true;
        }
        return this.needParentPathText;
    }

    public IRestUiModel[] setModelsOnDialog() {
        String id;
        String base;
        String title;
        ArrayList<AbstractWadlModel> models = new ArrayList<AbstractWadlModel>();
        ArrayList<AbstractWadlModel> parents = new ArrayList<AbstractWadlModel>();
        if (this.txtTitle != null && this.txtTitle.isEnabled() && !StringUtil.isEmpty((CharSequence)(title = this.txtTitle.getText()))) {
            Application application = new Application(title);
            models.add(application);
            parents.add(application);
        }
        if (this.txtBase != null && this.txtBase.isEnabled() && !StringUtil.isEmpty((CharSequence)(base = this.txtBase.getText()))) {
            Resources resources = new Resources(base);
            String alias = this.txtAlias.getText();
            if (!StringUtil.isEmpty((CharSequence)alias)) {
                resources.setTitle(alias);
            }
            models.add(resources);
        }
        if (this.txtPath != null) {
            String path;
            Resource[] resourceArray = this.parentResource;
            int alias = this.parentResource.length;
            int resources = 0;
            while (resources < alias) {
                Resource resource = resourceArray[resources];
                parents.add(resource);
                ++resources;
            }
            if (this.txtPath.isEnabled() && !StringUtil.isEmpty((CharSequence)(path = this.txtPath.getText()))) {
                if (path.startsWith("/")) {
                    path = StringUtil.removeStart((String)path, (String)"/");
                }
                if (path.endsWith("/")) {
                    path = StringUtil.removeEnd((String)path, (String)"/");
                }
                Resource resource = new Resource(path);
                int index = this.comboType.getSelectionIndex();
                String qType = this.apiContents[index];
                resource.setQueryType(qType);
                models.add(resource);
                parents.add(resource);
            }
        }
        if (this.txtId != null && this.txtId.isEnabled() && !StringUtil.isEmpty((CharSequence)(id = this.txtId.getText()))) {
            String description = this.txtDescription.getText();
            int nameIndex = this.comboName.getSelectionIndex();
            String name = "";
            if (nameIndex >= 0) {
                name = this.apiNames[nameIndex];
            }
            Method method = new Method();
            method.setId(id);
            if (description != null) {
                method.setDescription(description);
            }
            method.setName(name);
            models.add(method);
            parents.add(method);
        }
        this.modelsOnDialog = models.toArray(new IRestUiModel[0]);
        return parents.toArray(new IRestUiModel[0]);
    }

    protected void okPressed() {
        this.setModelsOnDialog();
        super.okPressed();
    }

    public IRestUiModel[] getModelListFromTree() {
        return this.modelsFromTree;
    }

    public IRestUiModel[] getModelsOnDialog() {
        return this.modelsOnDialog;
    }

    public Param[] getNewParams() {
        ArrayList<Param> list = new ArrayList<Param>();
        for (Param param : this.paramsOnTable) {
            if (this.paramsPairs.containsValue(param)) continue;
            list.add(param);
        }
        return list.toArray(new Param[0]);
    }

    public Map<Param, Param> getParamsPairs() {
        return this.paramsPairs;
    }

    public int open() {
        isCreated = true;
        return super.open();
    }

    public boolean close() {
        isCreated = false;
        return super.close();
    }

    public static boolean isCreated() {
        return isCreated;
    }

    public boolean hasToRun() {
        return this.toRun;
    }

    public void modifyText(ModifyEvent e) {
        Button button;
        if (this.txtId != null && (button = this.getButton(0)) != null && !button.isDisposed()) {
            boolean isOK = this.checkRequired(this.txtId, false, true);
            button.setEnabled(isOK);
            if (isOK) {
                this.setErrorMessage(null);
            }
            this.itemAdd.setEnabled(this.setModelsOnDialog().length > 0);
        }
        this.changeSaveAndRunButtonEnableStatus();
    }

    private boolean checkRequired(Text text, boolean parentRequired, boolean isOKEnabled) {
        if (parentRequired) {
            String str = text.getText();
            if (StringUtil.isEmpty((CharSequence)str)) {
                if (text.equals(this.txtPath) && this.txtPP != null) {
                    str = this.txtPP.getText();
                } else if (text.equals(this.txtPP)) {
                    str = this.txtPath.getText();
                }
            }
            if (StringUtil.isEmpty((CharSequence)str)) {
                String errorMsg = null;
                errorMsg = text.equals(this.txtId) ? RestUIMessages.UI_ERR_API_REQUIRED : (text.equals(this.txtPath) || text.equals(this.txtPP) ? RestUIMessages.UI_ERR_PATH_REQUIRED : (text.equals(this.txtBase) ? RestUIMessages.UI_ERR_BASEURI_REQUIRED : RestUIMessages.UI_ERR_SERVICE_REQUIRED));
                this.setErrorMessage(errorMsg);
                isOKEnabled = false;
            }
        } else {
            boolean bl = parentRequired = !StringUtil.isEmpty((CharSequence)text.getText());
        }
        if (text.equals(this.txtId)) {
            return this.checkRequired(this.txtPath, parentRequired, isOKEnabled);
        }
        if (text.equals(this.txtPath) || text.equals(this.txtPP)) {
            return this.checkRequired(this.txtBase, parentRequired, isOKEnabled);
        }
        if (text.equals(this.txtBase)) {
            return this.checkRequired(this.txtTitle, parentRequired, isOKEnabled);
        }
        return isOKEnabled;
    }

    private void changeSaveAndRunButtonEnableStatus() {
        Button button = this.getButton(1000);
        if (button != null && !button.isDisposed()) {
            boolean enabled = false;
            if (this.txtTitle.getText().length() > 0 && this.txtBase.getText().length() > 0) {
                enabled = true;
            }
            button.setEnabled(enabled);
        }
    }
}

