/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.rest.ui.preferences.IRestAuthPreference;

public abstract class AbstractAuthPreference
implements IRestAuthPreference {
    public void recursiveSetEnabled(Control ctrl, boolean enabled) {
        if (ctrl instanceof Composite) {
            Composite comp = (Composite)ctrl;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.recursiveSetEnabled(c, enabled);
                ++n2;
            }
        } else {
            ctrl.setEnabled(enabled);
        }
    }

    protected String getKeyByAppId(String originalKey, String appId) {
        String result = originalKey;
        if (appId != null && appId.length() > 0) {
            result = String.valueOf(result) + "." + appId;
        }
        return result;
    }

    protected Composite createComposite(Composite parent, int numColumn, int horizontalSpan) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(numColumn, false);
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true, horizontalSpan, 1);
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Composite createComposite(Composite parent, int numColumn) {
        return this.createComposite(parent, numColumn, 1);
    }

    protected Group createGroup(Composite parent, String title, int numColumn, int horizontalSpan) {
        Group group = new Group(parent, 0);
        group.setText(title);
        GridLayout layout = new GridLayout(numColumn, false);
        group.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true, horizontalSpan, 1);
        group.setLayoutData((Object)data);
        return group;
    }

    protected Label createLabel(Composite parent, String string) {
        Label l = new Label(parent, 128);
        l.setText(string);
        return l;
    }

    protected Button createButton(Composite parent, String string, int width, int height) {
        return this.createButton(parent, 8, string, width, height);
    }

    protected Button createButton(Composite parent, int style, String string, int width, int height) {
        Button b = new Button(parent, style);
        b.setText(string);
        if (width > 0 && height > 0) {
            b.setSize(width, height);
        }
        return b;
    }

    protected void createSeparator(Composite parent, int horizontalSpan) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = horizontalSpan;
        separator.setLayoutData((Object)gridData);
    }

    protected Text createText(Composite parent, int widthHint, int horizontalSpan) {
        return this.createText(parent, 2052, widthHint, horizontalSpan);
    }

    protected Text createText(Composite parent, int textStyle, int widthHint, int horizontalSpan) {
        return this.createText(parent, textStyle, 768, widthHint, horizontalSpan);
    }

    protected Text createText(Composite parent, int textStyle, int layoutStyle, int widthHint, int horizontalSpan) {
        Text text = new Text(parent, textStyle);
        GridData gd = new GridData(layoutStyle);
        if (widthHint != 0) {
            gd.widthHint = widthHint;
        }
        gd.horizontalSpan = horizontalSpan;
        text.setLayoutData((Object)gd);
        return text;
    }

    protected Button createRadioButton(Composite parent, String title, String dataKey, String dataValue) {
        Button radio = this.createButton(parent, 16, title, 0, 0);
        radio.setData(dataKey, (Object)dataValue);
        return radio;
    }

    protected String getValue(IPreferenceStore store, String key, String appId, boolean isDefault) {
        if (isDefault) {
            return this.getDefault(store, key, appId);
        }
        return this.getValue(store, key, appId);
    }

    protected String getValue(IPreferenceStore store, String key, String appId) {
        String defaultValue = store.getDefaultString(key);
        String value = store.getString(key = this.getKeyByAppId(key, appId));
        if (value.length() == 0) {
            value = defaultValue;
        }
        return value;
    }

    protected void setValue(IPreferenceStore store, String key, String value, String appId) {
        key = this.getKeyByAppId(key, appId);
        store.setValue(key, value);
    }

    protected String getDefault(IPreferenceStore store, String key, String appId) {
        return store.getDefaultString(key);
    }

    protected void setDefault(IPreferenceStore store, String key, String value, String appId) {
        store.setDefault(key, value);
    }
}

