/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.preferences;

import java.net.URI;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.run.RunHistoryManager;
import org.tizen.common.rest.ui.preferences.AbstractPreferencePage;

public class RunPreferencePage
extends AbstractPreferencePage {
    public static final String ID_PREFERENCE = "org.tizen.common.rest.ui.preferences.run";
    private static final int HISTORY_SIZE_MIN = 1;
    private static final int HISTORY_SIZE_MAX = 20;
    private Spinner historySpin;
    private Button useProxyBtn;
    private Text proxyHostText;
    private Text proxyPortText;
    private Button useProxyAuthBtn;
    private Text proxyUserText;
    private Text proxyPasswordText;
    private Group proxyGroup;
    private Group proxySubGroup;
    private Button resSaveAutoBtn;
    private Button resSaveAskBtn;
    private Button resSaveOverwriteBtn;

    public RunPreferencePage() {
        super(RestUIMessages.RunPreferencePage_description);
    }

    @Override
    protected Composite createContentArea(Composite parent) {
        int nColumns = 1;
        Composite composite = this.createComposite(parent, nColumns);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createRunHistorySizeContent(composite);
        this.createProxySettingContent(composite);
        this.createResponseAutoSaveContent(composite);
        return composite;
    }

    @Override
    protected void loadData() {
        this.historySpin.setSelection(Integer.parseInt(this.getValue("PREF_KEY_RUN_HISTORY_SIZE")));
        this.useProxyBtn.setSelection(Boolean.parseBoolean(this.getValue("PREF_KEY_USE_PROXY")));
        this.proxyHostText.setText(this.getValue("PREF_KEY_PROXY_HOST"));
        this.proxyPortText.setText(this.getValue("PREF_KEY_PROXY_PORT"));
        this.useProxyAuthBtn.setSelection(Boolean.parseBoolean(this.getValue("PREF_KEY_USE_PROXY_AUTH")));
        this.proxyUserText.setText(this.getValue("PREF_KEY_PROXY_USER"));
        this.proxyPasswordText.setText(this.getValue("PREF_KEY_PROXY_PASSWORD"));
        this.resSaveAutoBtn.setSelection(Boolean.parseBoolean(this.getValue("PREF_KEY_RES_SAVE_AUTO")));
        this.resSaveAskBtn.setSelection(Boolean.parseBoolean(this.getValue("PREF_KEY_RES_SAVE_ASK")));
        this.resSaveOverwriteBtn.setSelection(Boolean.parseBoolean(this.getValue("PREF_KEY_RES_SAVE_OVERWRITE")));
        this.updateUIState();
    }

    private void createRunHistorySizeContent(Composite parent) {
        Group historyGroup = new Group(parent, 0);
        historyGroup.setText(RestUIMessages.RunPreferencePage_history_group);
        historyGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertVerticalDLUsToPixels(4);
        historyGroup.setLayout((Layout)layout);
        Label historySizeLabel = new Label((Composite)historyGroup, 0);
        historySizeLabel.setText(RestUIMessages.RunPreferencePage_history_label);
        this.historySpin = new Spinner((Composite)historyGroup, 2052);
        GridData gd = new GridData();
        gd.widthHint = 60;
        this.historySpin.setLayoutData((Object)gd);
        this.historySpin.setMinimum(1);
        this.historySpin.setMaximum(20);
    }

    private void createProxySettingContent(Composite parent) {
        this.useProxyBtn = new Button(parent, 32);
        this.useProxyBtn.setText(RestUIMessages.RunPreferencePage_useProxyBtn_text);
        GridData gd = new GridData(768);
        gd.verticalIndent = 10;
        this.useProxyBtn.setLayoutData((Object)gd);
        this.useProxyBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunPreferencePage.this.updateUIState();
                RunPreferencePage.this.validate();
            }
        });
        this.proxyGroup = new Group(parent, 0);
        this.proxyGroup.setText(RestUIMessages.RunPreferencePage_proxy_group_name);
        this.proxyGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertVerticalDLUsToPixels(4);
        this.proxyGroup.setLayout((Layout)layout);
        Label proxyHostLabel = new Label((Composite)this.proxyGroup, 0);
        proxyHostLabel.setText(RestUIMessages.RunPreferencePage_proxyHostLabel_text);
        this.proxyHostText = new Text((Composite)this.proxyGroup, 2052);
        this.proxyHostText.setLayoutData((Object)new GridData(768));
        this.proxyHostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                RunPreferencePage.this.validate();
            }
        });
        Label proxyPortLabel = new Label((Composite)this.proxyGroup, 0);
        proxyPortLabel.setText(RestUIMessages.RunPreferencePage_proxyPortLabel_text);
        this.proxyPortText = new Text((Composite)this.proxyGroup, 2052);
        this.proxyPortText.setLayoutData((Object)new GridData(768));
        this.proxyPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                RunPreferencePage.this.validate();
            }
        });
        this.useProxyAuthBtn = new Button((Composite)this.proxyGroup, 32);
        this.useProxyAuthBtn.setText(RestUIMessages.RunPreferencePage_useProxyAuthBtn_text);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.useProxyAuthBtn.setLayoutData((Object)gd);
        this.useProxyAuthBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunPreferencePage.this.updateUIState();
                RunPreferencePage.this.validate();
            }
        });
        this.proxySubGroup = new Group((Composite)this.proxyGroup, 0);
        this.proxySubGroup.setText(RestUIMessages.RunPreferencePage_proxy_subGroup_name);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.proxySubGroup.setLayoutData((Object)gd);
        layout = new GridLayout(2, false);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertVerticalDLUsToPixels(4);
        this.proxySubGroup.setLayout((Layout)layout);
        Label proxyUserLabel = new Label((Composite)this.proxySubGroup, 0);
        proxyUserLabel.setText(RestUIMessages.RunPreferencePage_proxyUserLabel_text);
        this.proxyUserText = new Text((Composite)this.proxySubGroup, 2052);
        this.proxyUserText.setLayoutData((Object)new GridData(768));
        this.proxyUserText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RunPreferencePage.this.validate();
            }
        });
        Label proxyPasswordLabel = new Label((Composite)this.proxySubGroup, 0);
        proxyPasswordLabel.setText(RestUIMessages.RunPreferencePage_proxyPasswordLabel_text);
        this.proxyPasswordText = new Text((Composite)this.proxySubGroup, 0x400800);
        this.proxyPasswordText.setLayoutData((Object)new GridData(768));
        this.proxyPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RunPreferencePage.this.validate();
            }
        });
    }

    private void createResponseAutoSaveContent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(RestUIMessages.RunPreferencePage_resSaveGroup_text);
        GridData gd = new GridData(768);
        gd.verticalIndent = 10;
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertVerticalDLUsToPixels(4);
        group.setLayout((Layout)layout);
        this.resSaveAutoBtn = new Button((Composite)group, 32);
        this.resSaveAutoBtn.setText(RestUIMessages.RunPreferencePage_resSaveAutoBtn_text);
        gd = new GridData(768);
        this.resSaveAutoBtn.setLayoutData((Object)gd);
        this.resSaveAutoBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunPreferencePage.this.validate();
            }
        });
        this.resSaveAskBtn = new Button((Composite)group, 32);
        this.resSaveAskBtn.setText(RestUIMessages.RunPreferencePage_resSaveAskBtn_text);
        gd = new GridData(768);
        this.resSaveAskBtn.setLayoutData((Object)gd);
        this.resSaveAskBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunPreferencePage.this.validate();
            }
        });
        this.resSaveOverwriteBtn = new Button((Composite)group, 32);
        this.resSaveOverwriteBtn.setText(RestUIMessages.RunPreferencePage_resSaveOverwriteBtn_text);
        gd = new GridData(768);
        this.resSaveOverwriteBtn.setLayoutData((Object)gd);
        this.resSaveOverwriteBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunPreferencePage.this.validate();
            }
        });
    }

    protected void validate() {
        boolean isValid = true;
        String message = null;
        if (this.useProxyBtn.getSelection()) {
            String str;
            if (isValid) {
                str = this.proxyHostText.getText();
                try {
                    URIUtil.toURL((URI)new URI("http://" + str));
                }
                catch (Exception exception) {
                    isValid = false;
                    message = RestUIMessages.RunPreferencePage_proxyHost_wrong_message;
                }
            }
            if (isValid) {
                str = this.proxyPortText.getText();
                try {
                    Integer.parseInt(str);
                }
                catch (NumberFormatException numberFormatException) {
                    isValid = false;
                    message = RestUIMessages.RunPreferencePage_proxyPort_wrong_message;
                }
            }
            if (this.useProxyAuthBtn.getSelection()) {
                if (isValid && ((str = this.proxyUserText.getText()) == null || str.length() == 0)) {
                    isValid = false;
                    message = RestUIMessages.RunPreferencePage_proxyUser_empty_message;
                }
                if (isValid && ((str = this.proxyPasswordText.getText()) == null || str.length() == 0)) {
                    isValid = false;
                    message = RestUIMessages.RunPreferencePage_proxyPassword_empty_message;
                }
            }
        }
        this.setValid(isValid);
        if (message != null) {
            this.setErrorMessage(message);
        } else {
            this.setErrorMessage(null);
            this.setMessage("");
        }
    }

    private void updateUIState() {
        Control[] children;
        boolean useProxy = this.useProxyBtn.getSelection();
        this.proxyGroup.setEnabled(useProxy);
        Control[] controlArray = children = this.proxyGroup.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setEnabled(useProxy);
            ++n2;
        }
        boolean useProxyAuth = this.useProxyAuthBtn.getSelection();
        if (!useProxy) {
            useProxyAuth = false;
        }
        children = this.proxySubGroup.getChildren();
        this.proxySubGroup.setEnabled(useProxyAuth);
        Control[] controlArray2 = children;
        int n3 = children.length;
        n = 0;
        while (n < n3) {
            Control child = controlArray2[n];
            child.setEnabled(useProxyAuth);
            ++n;
        }
    }

    @Override
    protected void performApply() {
        int size = this.historySpin.getSelection();
        this.setValue("PREF_KEY_RUN_HISTORY_SIZE", Integer.toString(size));
        RunHistoryManager.getInstance().updateHistorySize(size);
        this.setValue("PREF_KEY_USE_PROXY", Boolean.toString(this.useProxyBtn.getSelection()));
        this.setValue("PREF_KEY_PROXY_HOST", this.proxyHostText.getText());
        this.setValue("PREF_KEY_PROXY_PORT", this.proxyPortText.getText());
        this.setValue("PREF_KEY_USE_PROXY_AUTH", Boolean.toString(this.useProxyAuthBtn.getSelection()));
        this.setValue("PREF_KEY_PROXY_USER", this.proxyUserText.getText());
        this.setValue("PREF_KEY_PROXY_PASSWORD", this.proxyPasswordText.getText());
        this.setValue("PREF_KEY_RES_SAVE_AUTO", Boolean.toString(this.resSaveAutoBtn.getSelection()));
        this.setValue("PREF_KEY_RES_SAVE_ASK", Boolean.toString(this.resSaveAskBtn.getSelection()));
        this.setValue("PREF_KEY_RES_SAVE_OVERWRITE", Boolean.toString(this.resSaveOverwriteBtn.getSelection()));
    }

    protected void performDefaults() {
        this.historySpin.setSelection(Integer.parseInt(this.getDefault("PREF_KEY_RUN_HISTORY_SIZE")));
        this.useProxyBtn.setSelection(Boolean.parseBoolean(this.getDefault("PREF_KEY_USE_PROXY")));
        this.proxyHostText.setText(this.getDefault("PREF_KEY_PROXY_HOST"));
        this.proxyPortText.setText(this.getDefault("PREF_KEY_PROXY_PORT"));
        this.useProxyAuthBtn.setSelection(Boolean.parseBoolean(this.getDefault("PREF_KEY_USE_PROXY_AUTH")));
        this.proxyUserText.setText(this.getDefault("PREF_KEY_PROXY_USER"));
        this.proxyPasswordText.setText(this.getDefault("PREF_KEY_PROXY_PASSWORD"));
        this.resSaveAutoBtn.setSelection(Boolean.parseBoolean(this.getDefault("PREF_KEY_RES_SAVE_AUTO")));
        this.resSaveAskBtn.setSelection(Boolean.parseBoolean(this.getDefault("PREF_KEY_RES_SAVE_ASK")));
        this.resSaveOverwriteBtn.setSelection(Boolean.parseBoolean(this.getDefault("PREF_KEY_RES_SAVE_OVERWRITE")));
        this.updateUIState();
        super.performDefaults();
    }
}

