/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.wizards;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.constants.ISwaggerConstants;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.Doc;
import org.tizen.common.rest.model.schema.IWadlModel;
import org.tizen.common.rest.model.schema.Method;
import org.tizen.common.rest.model.schema.Param;
import org.tizen.common.rest.model.schema.ParamStyle;
import org.tizen.common.rest.model.schema.Representation;
import org.tizen.common.rest.model.schema.Request;
import org.tizen.common.rest.model.schema.Resource;
import org.tizen.common.rest.model.schema.Resources;
import org.tizen.common.rest.model.schema.Response;
import org.tizen.common.rest.ui.wizards.AbstractOperation;
import org.tizen.common.rest.util.OutputUtil;

public class SwaggerExportOperation
extends AbstractOperation
implements ISwaggerConstants {
    private IProgressMonitor monitor;
    private Application application;
    private String version;

    public SwaggerExportOperation(Application application, String filename, String version) {
        super(filename);
        this.application = application;
        this.version = version;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        block22: {
            this.monitor = monitor;
            int totalWork = -1;
            this.monitor.beginTask("Swagger file Export", totalWork);
            if (this.getFileName() != null) {
                File file = new File(this.getFileName());
                try {
                    JsonObject json = this.createSwaggerRoot(this.application);
                    Gson gson = OutputUtil.gsonForPrettyPrinting;
                    String jsonString = gson.toJson((JsonElement)json);
                    monitor.worked(1);
                    if (jsonString == null || jsonString.length() == 0) {
                        this.addError(RestUIMessages.SwaggerImportOperation_error_read, null);
                        break block22;
                    }
                    FileOutputStream out = null;
                    OutputStreamWriter writer = null;
                    try {
                        try {
                            out = new FileOutputStream(file);
                            writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
                            writer.append(jsonString);
                            monitor.worked(1);
                        }
                        catch (FileNotFoundException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
        this.monitor.done();
    }

    private JsonObject createSwaggerRoot(Application app) {
        JsonObject root = new JsonObject();
        root.addProperty("swagger", "2.0");
        String title = app.getTitle();
        if (title != null && title.length() > 0) {
            JsonObject info = new JsonObject();
            info.addProperty("title", title);
            info.addProperty("version", this.version);
            root.add("info", (JsonElement)info);
        }
        ArrayList<JsonPrimitive> produceList = new ArrayList<JsonPrimitive>();
        Resources resources = this.processResources(root, app);
        if (resources != null) {
            this.processResource(root, resources, produceList);
            if (produceList.size() > 0) {
                JsonArray produceArray = new JsonArray();
                int i = 0;
                while (i < produceList.size()) {
                    produceArray.add((JsonElement)produceList.get(i));
                    ++i;
                }
                root.add("produces", (JsonElement)produceArray);
            }
        }
        return root;
    }

    private void processResource(JsonObject root, Resources resources, List<JsonPrimitive> produceList) {
        List<Resource> resList = resources.getResource();
        if (resList != null && resList.size() > 0) {
            JsonObject pathsObject = new JsonObject();
            int i = 0;
            while (i < resList.size()) {
                Resource res = resList.get(i);
                String pathString = res.getPath();
                this.processChildResource(produceList, pathsObject, res, pathString);
                ++i;
            }
            root.add("paths", (JsonElement)pathsObject);
        }
    }

    private void processChildResource(List<JsonPrimitive> produceList, JsonObject pathsObject, Resource res, String pathString) {
        List<IWadlModel> methodOrResource = res.getMethodOrResource();
        if (methodOrResource != null && methodOrResource.size() > 0) {
            JsonObject path = null;
            int j = 0;
            while (j < methodOrResource.size()) {
                IWadlModel model = methodOrResource.get(j);
                if (model instanceof Resource) {
                    Resource r = (Resource)model;
                    String newPathString = String.valueOf(pathString) + "/" + r.getPath();
                    this.processChildResource(produceList, pathsObject, r, newPathString);
                } else if (model instanceof Method) {
                    Method method = (Method)model;
                    if (path == null) {
                        path = new JsonObject();
                    }
                    this.processMethod(produceList, method, path);
                }
                this.monitor.worked(1);
                ++j;
            }
            if (path != null) {
                pathsObject.add(pathString, path);
            }
        } else {
            JsonObject path = new JsonObject();
            pathsObject.add(pathString, (JsonElement)path);
        }
    }

    private void processMethod(List<JsonPrimitive> produceList, Method method, JsonObject path) {
        List<Response> resList;
        List<Param> paramList;
        Request req;
        String id;
        JsonObject methodObject = new JsonObject();
        String methodName = method.getName();
        String desc = method.getDescription();
        if (desc != null && desc.length() > 0) {
            methodObject.addProperty("description", desc);
        }
        if ((id = method.getId()) != null && id.length() > 0) {
            methodObject.addProperty("operationId", id);
        }
        if ((req = method.getRequest()) != null && (paramList = req.getParam()) != null && paramList.size() > 0) {
            JsonArray paramObjArray = this.processParam(paramList);
            methodObject.add("parameters", (JsonElement)paramObjArray);
        }
        if ((resList = method.getResponse()) != null && resList.size() > 0) {
            this.processResponse(produceList, methodObject, resList);
        }
        path.add(methodName, (JsonElement)methodObject);
    }

    private void processResponse(List<JsonPrimitive> produceList, JsonObject methodObject, List<Response> resList) {
        int i = 0;
        while (i < resList.size()) {
            Response res = resList.get(i);
            List<Representation> repList = res.getRepresentation();
            if (repList != null && repList.size() > 0) {
                int j = 0;
                while (j < repList.size()) {
                    JsonPrimitive primitive;
                    Representation rep = repList.get(j);
                    String mediaType = rep.getMediaType();
                    if (mediaType != null && mediaType.length() > 0 && !produceList.contains(primitive = new JsonPrimitive(mediaType))) {
                        produceList.add(primitive);
                    }
                    ++j;
                }
            }
            JsonObject resObject = new JsonObject();
            methodObject.add("responses", (JsonElement)resObject);
            JsonObject defaultObject = new JsonObject();
            resObject.add("default", (JsonElement)defaultObject);
            defaultObject.addProperty("description", "success");
            JsonObject schemaObject = new JsonObject();
            List<Param> paramList = res.getParam();
            if (paramList != null && paramList.size() > 0) {
                this.processSchema(schemaObject, paramList);
            }
            ++i;
        }
    }

    private void processSchema(JsonObject schemaObject, List<Param> paramList) {
        JsonObject propObject = new JsonObject();
        JsonArray requiredObject = new JsonArray();
        int i = 0;
        while (i < paramList.size()) {
            Param p = paramList.get(i);
            String name = p.getName();
            String typeName = "string";
            QName type = p.getType();
            if (type != null) {
                typeName = type.getLocalPart();
            }
            JsonObject paramObject = new JsonObject();
            paramObject.addProperty("type", typeName);
            propObject.add(name, (JsonElement)paramObject);
            boolean required = p.isRequired();
            if (required) {
                requiredObject.add((JsonElement)new JsonPrimitive(name));
            }
            ++i;
        }
        schemaObject.add("properties", (JsonElement)propObject);
        schemaObject.add("required", (JsonElement)requiredObject);
    }

    private JsonArray processParam(List<Param> paramList) {
        JsonArray array = new JsonArray();
        int i = 0;
        while (i < paramList.size()) {
            JsonObject paramObject = new JsonObject();
            Param p = paramList.get(i);
            String styleString = "query";
            ParamStyle style = p.getStyle();
            if (style != null) {
                switch (style) {
                    case TEMPLATE: {
                        styleString = "path";
                        break;
                    }
                    case HEADER: {
                        styleString = "header";
                        break;
                    }
                    case PLAIN: {
                        styleString = "body";
                        break;
                    }
                }
            }
            String name = p.getName();
            String typeName = "string";
            QName type = p.getType();
            if (type != null) {
                typeName = type.getLocalPart();
            }
            boolean required = p.isRequired();
            String desc = "";
            List<Doc> docList = p.getDoc();
            if (docList != null && docList.size() > 0) {
                desc = docList.get(0).getTitle();
            }
            paramObject.addProperty("in", styleString);
            paramObject.addProperty("name", name);
            paramObject.addProperty("description", desc);
            paramObject.addProperty("type", typeName);
            paramObject.addProperty("required", Boolean.valueOf(required));
            array.add((JsonElement)paramObject);
            ++i;
        }
        return array;
    }

    private Resources processResources(JsonObject root, Application app) {
        Resources resources = null;
        List<Resources> resourcesList = app.getResources();
        if (resourcesList != null && resourcesList.size() > 0) {
            resources = resourcesList.get(0);
            String base = resources.getBase();
            try {
                URL url = new URL(base);
                String protocol = url.getProtocol();
                String host = url.getHost();
                int port = url.getPort();
                if (port > 0) {
                    host = String.valueOf(host) + ":" + port;
                }
                String path = url.getPath();
                root.addProperty("host", host);
                root.addProperty("basePath", path);
                JsonArray schemeArray = new JsonArray();
                schemeArray.add((JsonElement)new JsonPrimitive(protocol));
                root.add("schemes", (JsonElement)schemeArray);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
        }
        return resources;
    }
}

