/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.explorer;

import java.text.Collator;
import java.util.Locale;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.tizen.sdblib.service.FileEntry;

class FileSorter
extends ViewerSorter {
    private static final int ASCENDING = 0;
    private static final int DESCENDING = 1;
    private int column;
    private int direction;
    private Collator collator = Collator.getInstance(Locale.getDefault());

    FileSorter() {
    }

    public int category(Object element) {
        if (((FileEntry)element).getName().equals("..")) {
            return 0;
        }
        return ((FileEntry)element).isDirectory() ? 1 : 2;
    }

    public void doSort(int column) {
        if (column == this.column) {
            this.direction = 1 - this.direction;
        } else {
            this.column = column;
            this.direction = 0;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int rc = 0;
        FileEntry p1 = (FileEntry)e1;
        FileEntry p2 = (FileEntry)e2;
        switch (this.column) {
            case 0: {
                rc = this.collator.compare(p1.getName(), p2.getName());
                break;
            }
            case 1: {
                rc = this.collator.compare(p1.getDate(), p2.getDate());
                break;
            }
            case 2: {
                int n = rc = Long.valueOf(p1.getSize()) > Long.valueOf(p2.getSize()) ? 1 : -1;
            }
        }
        if (this.direction == 1) {
            rc = -rc;
        }
        return rc;
    }
}

