/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.logview.view;

import javafx.beans.value.ObservableValue;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import org.tizen.common.connection.logview.controller.LogFilterTableColumn;
import org.tizen.common.connection.logview.model.LogModel;
import org.tizen.common.connection.logview.view.LogItem;
import org.tizen.common.connection.logview.view.LogTab;

public class LogTableView
extends TableView<LogItem> {
    private LogModel logModel;
    private TableColumn<LogItem, String> time;
    private LogFilterTableColumn<LogItem, String> level;
    private LogFilterTableColumn<LogItem, String> pid;
    private LogFilterTableColumn<LogItem, String> tid;
    private LogFilterTableColumn<LogItem, String> tag;
    private TableColumn<LogItem, String> message;

    public LogTableView(LogModel model) {
        this.logModel = model;
        this.time = new TableColumn(LogTab.LABEL_TIME);
        this.level = new LogFilterTableColumn(this.logModel, LogTab.LABEL_LEVEL);
        this.pid = new LogFilterTableColumn(this.logModel, LogTab.LABEL_PID);
        this.tid = new LogFilterTableColumn(this.logModel, LogTab.LABEL_TID);
        this.tag = new LogFilterTableColumn(this.logModel, LogTab.LABEL_TAG);
        this.message = new TableColumn(LogTab.LABEL_MESSAGE);
        this.time.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<LogItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<LogItem, String> param) {
                return ((LogItem)param.getValue()).timeProperty();
            }
        });
        this.level.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<LogItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<LogItem, String> param) {
                return ((LogItem)param.getValue()).levelProperty();
            }
        });
        this.pid.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<LogItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<LogItem, String> param) {
                return ((LogItem)param.getValue()).pidProperty();
            }
        });
        this.tid.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<LogItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<LogItem, String> param) {
                return ((LogItem)param.getValue()).tidProperty();
            }
        });
        this.tag.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<LogItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<LogItem, String> param) {
                return ((LogItem)param.getValue()).tagProperty();
            }
        });
        this.message.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<LogItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<LogItem, String> param) {
                return ((LogItem)param.getValue()).messageProperty();
            }
        });
        this.time.setSortable(false);
        this.time.prefWidthProperty().bind((ObservableValue)this.widthProperty().multiply(0.13));
        this.level.setSortable(false);
        this.level.prefWidthProperty().bind((ObservableValue)this.widthProperty().multiply(0.07));
        this.pid.setSortable(false);
        this.pid.prefWidthProperty().bind((ObservableValue)this.widthProperty().multiply(0.06));
        this.tid.setSortable(false);
        this.tid.prefWidthProperty().bind((ObservableValue)this.widthProperty().multiply(0.06));
        this.tag.setSortable(false);
        this.tag.prefWidthProperty().bind((ObservableValue)this.widthProperty().multiply(0.1));
        this.message.setStyle("-fx-alignment: CENTER-LEFT;");
        this.message.setSortable(false);
        this.message.prefWidthProperty().bind((ObservableValue)this.widthProperty().multiply(0.6));
        this.getColumns().add(this.time);
        this.getColumns().add(this.level);
        this.getColumns().add(this.pid);
        this.getColumns().add(this.tid);
        this.getColumns().add(this.tag);
        this.getColumns().add(this.message);
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }
}

