/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.toolbar;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.sdblib.IDevice;

public class DeviceDescriptor
implements Comparable<DeviceDescriptor> {
    private Logger logger = LoggerFactory.getLogger(DeviceDescriptor.class);
    private int deviceType;
    private int deviceState;
    private IDevice device;
    private String serialId;
    private String descriptorName;
    private String tooltipName;

    public DeviceDescriptor(String deviceSerial) {
        this.serialId = deviceSerial;
        this.deviceState = 16;
    }

    public DeviceDescriptor(String deviceSerial, String descriptorName) {
        this(deviceSerial);
        this.descriptorName = descriptorName;
    }

    public DeviceDescriptor(String deviceSerial, IDevice device) {
        this(deviceSerial);
        this.device = device;
    }

    public void setIDevice(IDevice device) {
        this.device = device;
    }

    public IDevice getIDevice() {
        return this.device;
    }

    public String getSerialId() {
        return this.serialId;
    }

    public void setSerialId(String serialId) {
        this.serialId = serialId;
    }

    @Override
    public int compareTo(DeviceDescriptor object) {
        DeviceDescriptor other = object;
        return Integer.compare(this.getItemGroup(this.deviceType), this.getItemGroup(other.deviceType));
    }

    private int getItemGroup(int type) {
        if (type == 4) {
            return 1;
        }
        if (type == 1) {
            return 2;
        }
        if (type == 8 | type == 2) {
            return 3;
        }
        return 0;
    }

    public String getDescriptorName() {
        return this.descriptorName;
    }

    public void setDescriptorName(String descriptorName) {
        this.descriptorName = descriptorName;
    }

    public int getDeviceState() {
        return this.deviceState;
    }

    public void setDeviceState(int deviceState) {
        this.deviceState = deviceState;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(int deviceType) {
        this.deviceType = deviceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyIDeviceCreated() {
        DeviceDescriptor deviceDescriptor = this;
        synchronized (deviceDescriptor) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDevice getIDevice(boolean blocking, int waitSec) {
        if (!blocking) {
            return this.getIDevice();
        }
        DeviceDescriptor deviceDescriptor = this;
        synchronized (deviceDescriptor) {
            try {
                this.wait(waitSec);
            }
            catch (InterruptedException e) {
                this.logger.error("It is interrupted before main thread invokes: ", (Throwable)e);
            }
        }
        return this.device;
    }

    public String getTooltipName() {
        return this.tooltipName;
    }

    public void setTooltipName(String tooltipName) {
        this.tooltipName = tooltipName;
    }
}

