/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.opt;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.opt.AbstractTreeIteratorHandler;
import org.eclipse.jgit.pgm.opt.ObjectIdHandler;
import org.eclipse.jgit.pgm.opt.RefSpecHandler;
import org.eclipse.jgit.pgm.opt.RevCommitHandler;
import org.eclipse.jgit.pgm.opt.RevTreeHandler;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.NamedOptionDef;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Setter;

public class CmdLineParser
extends org.kohsuke.args4j.CmdLineParser {
    private final Repository db;
    private RevWalk walk;

    public CmdLineParser(Object bean) {
        this(bean, null);
    }

    public CmdLineParser(Object bean, Repository repo) {
        super(bean);
        if (repo == null && bean instanceof TextBuiltin) {
            repo = ((TextBuiltin)bean).getRepository();
        }
        this.db = repo;
    }

    public void parseArgument(String ... args) throws CmdLineException {
        ArrayList<String> tmp = new ArrayList<String>(args.length);
        for (int argi = 0; argi < args.length; ++argi) {
            int eq;
            String str = args[argi];
            if (str.equals("--")) {
                while (argi < args.length) {
                    tmp.add(args[argi++]);
                }
                break;
            }
            if (str.startsWith("--") && (eq = str.indexOf(61)) > 0) {
                tmp.add(str.substring(0, eq));
                tmp.add(str.substring(eq + 1));
                continue;
            }
            tmp.add(str);
        }
        super.parseArgument(tmp.toArray(new String[tmp.size()]));
    }

    public Repository getRepository() {
        if (this.db == null) {
            throw new IllegalStateException(CLIText.get().noGitRepositoryConfigured);
        }
        return this.db;
    }

    public RevWalk getRevWalk() {
        if (this.walk == null) {
            this.walk = new RevWalk(this.getRepository());
        }
        return this.walk;
    }

    public RevWalk getRevWalkGently() {
        return this.walk;
    }

    protected OptionHandler createOptionHandler(OptionDef o, Setter setter) {
        if (o instanceof NamedOptionDef) {
            return super.createOptionHandler(o, setter);
        }
        return super.createOptionHandler(new MyOptionDef(o), setter);
    }

    static {
        CmdLineParser.registerHandler(AbstractTreeIterator.class, AbstractTreeIteratorHandler.class);
        CmdLineParser.registerHandler(ObjectId.class, ObjectIdHandler.class);
        CmdLineParser.registerHandler(RefSpec.class, RefSpecHandler.class);
        CmdLineParser.registerHandler(RevCommit.class, RevCommitHandler.class);
        CmdLineParser.registerHandler(RevTree.class, RevTreeHandler.class);
    }

    static class MyOptionDef
    extends OptionDef {
        public MyOptionDef(OptionDef o) {
            super(o.usage(), o.metaVar(), o.required(), o.handler(), o.isMultiValued());
        }

        public String toString() {
            if (this.metaVar() == null) {
                return "ARG";
            }
            try {
                Field field = CLIText.class.getField(this.metaVar());
                String ret = field.get(CLIText.get()).toString();
                return ret;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return this.metaVar();
            }
        }
    }
}

