/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.file;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.file.Filter;
import org.tizen.common.util.CollectionUtil;

public class SimpleFileFilter
implements Filter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected List<Filter> includes = new ArrayList<Filter>();
    protected List<Filter> excludes = new ArrayList<Filter>();
    protected boolean bDefault = false;

    public SimpleFileFilter() {
        this(false);
    }

    public SimpleFileFilter(boolean bDefault) {
        this.bDefault = bDefault;
    }

    public void setDefault(boolean bDefault) {
        this.bDefault = bDefault;
    }

    public void clearIncludes() {
        this.includes.clear();
    }

    public void setIncludes(Filter ... filters) {
        this.clearIncludes();
        this.addIncludes(filters);
    }

    public void addIncludes(Filter ... filters) {
        Filter[] filterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            Filter filter = filterArray[n2];
            this.includes.add(filter);
            ++n2;
        }
        this.logger.debug("Include filters[{}] added", (Object)CollectionUtil.toString(filters));
    }

    public void clearExcludes() {
        this.excludes.clear();
    }

    public void setExcludes(Filter ... filters) {
        this.clearExcludes();
        this.addExcludes(filters);
    }

    public void addExcludes(Filter ... filters) {
        Filter[] filterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            Filter filter = filterArray[n2];
            this.excludes.add(filter);
            ++n2;
        }
        this.logger.trace("Excludes filters[{}] added", (Object)CollectionUtil.toString(filters));
    }

    public void removeExcludes(Filter ... filters) {
        this.excludes = this.removeFilters(this.excludes, filters);
    }

    private List<Filter> removeFilters(List<Filter> savedFilters, Filter ... removeFilters) {
        Filter[] filterArray = removeFilters;
        int n = removeFilters.length;
        int n2 = 0;
        while (n2 < n) {
            Filter filter = filterArray[n2];
            savedFilters.remove(filter);
            ++n2;
        }
        return savedFilters;
    }

    public void removeIncludes(Filter ... filters) {
        this.includes = this.removeFilters(this.includes, filters);
    }

    @Override
    public boolean accept(String cwd, String path) {
        this.logger.trace("Current working directory :{}, Path :{}", (Object)cwd, (Object)path);
        if (this.excludes.isEmpty() && this.includes.isEmpty()) {
            return this.bDefault;
        }
        this.logger.trace("Including filters :{}", this.includes);
        for (Filter filter : this.includes) {
            if (!filter.accept(cwd, path)) continue;
            this.logger.debug("Accept because of {}", (Object)filter);
            return true;
        }
        if (this.excludes.isEmpty()) {
            return false;
        }
        this.logger.trace("Excluding filters :{}", this.excludes);
        for (Filter filter : this.excludes) {
            if (!filter.accept(cwd, path)) continue;
            this.logger.debug("Deny because of {}", (Object)filter);
            return false;
        }
        if (this.includes.isEmpty()) {
            return true;
        }
        return this.bDefault;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.includes.size() + "/" + this.excludes.size() + "]";
    }

    public Filter[] getExcludes() {
        return this.excludes != null ? this.excludes.toArray(new Filter[0]) : null;
    }

    public Filter[] getIncludes() {
        return this.includes != null ? this.includes.toArray(new Filter[0]) : null;
    }
}

