/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.WorkingSetDescriptor;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;
import org.tizen.common.util.ProjectUtil;

public class WorkspaceUtil {
    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IProject[] getProjects() {
        return WorkspaceUtil.getWorkspace().getRoot().getProjects();
    }

    public static IProject[] getTizenWebProjects() {
        ArrayList<IProject> tizenWebProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = WorkspaceUtil.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (ProjectUtil.isTizenWebProject(project)) {
                tizenWebProjects.add(project);
            }
            ++n2;
        }
        return tizenWebProjects.toArray(new IProject[0]);
    }

    public static WorkingSetRegistry getWorkingSetRegistry() {
        return WorkbenchPlugin.getDefault().getWorkingSetRegistry();
    }

    public static WorkingSetDescriptor[] getWorkingSetDescriptors() {
        return WorkspaceUtil.getWorkingSetRegistry().getNewPageWorkingSetDescriptors();
    }

    public static String[] getIdsOfWorkingSetDescriptors() {
        ArrayList<String> workingSetList = new ArrayList<String>();
        WorkingSetDescriptor[] workingSetDescriptorArray = WorkspaceUtil.getWorkingSetDescriptors();
        int n = workingSetDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            WorkingSetDescriptor desc = workingSetDescriptorArray[n2];
            workingSetList.add(desc.getId());
            ++n2;
        }
        return workingSetList.toArray(new String[0]);
    }

    public static IWorkingSetManager getWorkingSetManager() {
        return PlatformUI.getWorkbench().getWorkingSetManager();
    }
}

