/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util.log;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.status.StatusLogger;
import org.eclipse.osgi.util.NLS;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.log.Messages;

@Plugin(name="FileAppender", category="Core", printObject=true)
public class FileAppender
extends AbstractAppender {
    private int bufferSize;
    private static final Logger logger = LogManager.getLogger(FileAppender.class);
    private static final StatusLogger statusLogger = StatusLogger.getLogger();
    private static final Timer TIMER = new Timer("File appender timer", true);
    protected String logPath;
    private OutputStream FILE_OUTPUT_STREAM;
    private FileAppenderScheduler SCHEDULER;
    protected final OutputStream NOOP_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }
    };
    protected final FileAppenderScheduler NOOP_SCHEDULER = new FileAppenderScheduler(this){

        @Override
        public void run() {
        }

        @Override
        public boolean cancel() {
            return true;
        }
    };

    public FileAppender(String logPath) {
        this(logPath, (Layout)PatternLayout.newBuilder().withPattern("[%d{yyyy.MM.dd HH:mm:ss}][%-5p] %F(%L) - %m%n").build(), 5000);
    }

    public FileAppender(String logPath, Layout layout) {
        this(logPath, layout, 5000);
    }

    public FileAppender(String logPath, Layout layout, int bufferSize) {
        super("TIZEN_FILE_APPENDER", null, layout, false);
        this.logPath = logPath;
        this.bufferSize = bufferSize;
        this.initializeAppender();
    }

    public synchronized String getLogPath() {
        return this.logPath;
    }

    public void start() {
        super.start();
        this.initializeAppender();
    }

    public void stop() {
        IOUtil.tryFlush(this.FILE_OUTPUT_STREAM);
        IOUtil.tryClose(this.FILE_OUTPUT_STREAM);
        super.stop();
    }

    public synchronized String setFilePath(String path) {
        IOUtil.tryFlush(this.FILE_OUTPUT_STREAM);
        IOUtil.tryClose(this.FILE_OUTPUT_STREAM);
        this.logPath = path;
        return this.initializeAppender();
    }

    public synchronized void setBufferSize(int bufferSize) {
        IOUtil.tryFlush(this.FILE_OUTPUT_STREAM);
        IOUtil.tryClose(this.FILE_OUTPUT_STREAM);
        this.bufferSize = bufferSize;
        this.initializeAppender();
    }

    public void append(LogEvent event) {
        try {
            try {
                this.FILE_OUTPUT_STREAM.write(this.getLayout().toByteArray(event));
            }
            catch (IOException e) {
                statusLogger.error(Messages.FileAppender_EXCEPTION_WRITING_LOG, (Throwable)e);
            }
            this.SCHEDULER.cancel();
            this.SCHEDULER = new FileAppenderScheduler();
            TIMER.scheduleAtFixedRate((TimerTask)this.SCHEDULER, 3000L, 3000L);
        }
        catch (Throwable t) {
            statusLogger.error(MessageFormat.format("Exception occurred while logging message: {0}", event.getMessage()), t);
        }
    }

    private synchronized String initializeAppender() {
        this.createLogFile(this.logPath);
        File logFile = new File(this.logPath);
        String message = "";
        if (!logFile.exists()) {
            File parent = logFile.getAbsoluteFile().getParentFile();
            if (parent != null) {
                parent.mkdirs();
                try {
                    logFile.createNewFile();
                }
                catch (IOException e) {
                    this.FILE_OUTPUT_STREAM = this.NOOP_OUTPUT_STREAM;
                    this.SCHEDULER = this.NOOP_SCHEDULER;
                    message = NLS.bind((String)Messages.FileAppender_EXCEPTION_CREATING_LOGFILE, (Object)this.logPath);
                    statusLogger.error(NLS.bind((String)Messages.FileAppender_EXCEPTION_CREATING_LOGFILE, (Object)this.logPath), (Throwable)e);
                    return message;
                }
            }
        } else if (logFile.isDirectory()) {
            this.FILE_OUTPUT_STREAM = this.NOOP_OUTPUT_STREAM;
            this.SCHEDULER = this.NOOP_SCHEDULER;
            message = NLS.bind((String)Messages.FileAppender_EXCEPTION_DIRECTORY_EXISTING, (Object)this.logPath);
            statusLogger.error(NLS.bind((String)Messages.FileAppender_EXCEPTION_DIRECTORY_EXISTING, (Object)this.logPath));
            return message;
        }
        IOUtil.tryFlush(this.FILE_OUTPUT_STREAM);
        IOUtil.tryClose(this.FILE_OUTPUT_STREAM);
        try {
            this.FILE_OUTPUT_STREAM = new BufferedOutputStream(new FileOutputStream(this.logPath, true), this.bufferSize);
        }
        catch (IOException e) {
            this.FILE_OUTPUT_STREAM = this.NOOP_OUTPUT_STREAM;
            this.SCHEDULER = this.NOOP_SCHEDULER;
            message = Messages.FileAppender_EXCEPTION_CREATING_BUFFER;
            statusLogger.error(Messages.FileAppender_EXCEPTION_CREATING_BUFFER, (Throwable)e);
            return message;
        }
        this.SCHEDULER = new FileAppenderScheduler();
        TIMER.scheduleAtFixedRate((TimerTask)this.SCHEDULER, 3000L, 3000L);
        return message;
    }

    private void createLogFile(String logPath2) {
    }

    public class FileAppenderScheduler
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileAppender fileAppender = FileAppender.this;
            synchronized (fileAppender) {
                try {
                    FileAppender.this.FILE_OUTPUT_STREAM.flush();
                }
                catch (IOException e) {
                    statusLogger.error("Exception flushing buffer", (Throwable)e);
                }
            }
        }
    }
}

