/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.gom.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.launch.ITizenNativeLaunchConfiguration;
import org.tizen.common.launch.ITizenWebLaunchConfiguration;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.SmartDevelopmentBridge;

public class GomLaunchData {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IProject project = null;
    private ILaunchConfiguration launchConfiguration = null;
    private String launchConfigurationName = null;
    private String buildConfiguration = null;
    private String mode = null;
    private LaunchShortcutExtension ext = null;
    private IDevice device = null;

    public GomLaunchData(IProject project, String configurationName, String buildConfiguration, String mode, LaunchShortcutExtension ext, IDevice device) {
        this.project = project;
        this.launchConfigurationName = configurationName;
        this.buildConfiguration = buildConfiguration;
        this.mode = mode;
        this.ext = ext;
        this.device = device;
    }

    public GomLaunchData(ILaunch launch) {
        this.launchConfiguration = launch.getLaunchConfiguration();
        this.launchConfigurationName = this.launchConfiguration.getName();
        this.mode = launch.getLaunchMode();
        String config_device_id = null;
        try {
            config_device_id = this.launchConfiguration.getAttribute("org.tizen.common.launch.device.id", "");
        }
        catch (CoreException e) {
            this.logger.error("Fail to get device id", (Throwable)e);
        }
        ITizenNativeLaunchConfiguration launchConfigurationAdapter = null;
        if (!"".equals(config_device_id)) {
            launchConfigurationAdapter = (ITizenNativeLaunchConfiguration)this.launchConfiguration.getAdapter(ITizenNativeLaunchConfiguration.class);
            IDevice[] devices = SmartDevelopmentBridge.getBridge().getDevices();
            this.device = launchConfigurationAdapter.getDeviceFromLaunchConfiguration(devices);
        } else {
            launchConfigurationAdapter = (ITizenWebLaunchConfiguration)this.launchConfiguration.getAdapter(ITizenWebLaunchConfiguration.class);
        }
        this.project = launchConfigurationAdapter.getProject();
    }

    public IProject getProject() {
        return this.project;
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.launchConfiguration;
    }

    public String getLaunchConfigurationName() {
        return this.launchConfigurationName;
    }

    public String getDataInfo() {
        if (this.device != null) {
            return String.valueOf(this.launchConfiguration.getName()) + " on " + (this.device.isEmulator() ? this.device.getDeviceName() : this.device.getSerialNumber());
        }
        return this.launchConfiguration.getName();
    }

    public String getMode() {
        return this.mode;
    }

    public IDevice getDevice() {
        return this.device;
    }

    public LaunchShortcutExtension getExt() {
        return this.ext;
    }

    public String getBuildConfiguration() {
        return this.buildConfiguration;
    }
}

