/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.gom.smartlaunch;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.gom.launch.GomLaunchData;
import org.tizen.common.gom.launch.IGomSmartLaunchShortcut;
import org.tizen.common.util.SWTUtil;

public class GomSmartLauncher {
    public static final String ATTR_CONFIG_DEVICE_ID = "org.tizen.common.launch.device.id";
    public static final String ATTR_CONFIG_DEVICE_IS_EMULATOR = "org.tizen.common.launch.device.emulator";
    public static final String ATTR_CONFIG_NO_DEVICE = "";
    private static final String DEBUG_ATTACH = "Attach";
    private static final Logger logger = LoggerFactory.getLogger(GomSmartLauncher.class);

    public static void smartLaunch(final GomLaunchData data) {
        if (data.getLaunchConfiguration() == null) {
            IGomSmartLaunchShortcut shortcut = null;
            try {
                shortcut = (IGomSmartLaunchShortcut)data.getExt().getConfigurationElement().createExecutableExtension("class");
                shortcut.smartLaunch(data);
            }
            catch (CoreException coreException) {
                logger.error("SmartLaunch: Failed to get a shortcut");
            }
        } else {
            SWTUtil.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    DebugUITools.launch((ILaunchConfiguration)data.getLaunchConfiguration(), (String)data.getMode());
                }
            });
        }
    }

    public static List getShortcuts(IProject project, String criMode) {
        LaunchConfigurationManager mgr = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
        List allShortcuts = mgr.getLaunchShortcuts((IResource)project);
        ArrayList<LaunchShortcutExtension> filteredShortcuts = new ArrayList<LaunchShortcutExtension>();
        for (LaunchShortcutExtension ext : allShortcuts) {
            if (WorkbenchActivityHelper.filterItem((Object)ext)) continue;
            Set modes = ext.getModes();
            for (String mode : modes) {
                if (!mode.equals(criMode)) continue;
                filteredShortcuts.add(ext);
            }
        }
        return filteredShortcuts;
    }

    public static LaunchShortcutExtension getDebugAttachShortcut(IProject project) {
        String mode = MODES.DEBUG.mode;
        List shortcuts = GomSmartLauncher.getShortcuts(project, mode);
        LaunchShortcutExtension ext = null;
        for (LaunchShortcutExtension extension : shortcuts) {
            String label = extension.getContextLabel(mode);
            if (label == null || !label.contains(DEBUG_ATTACH)) continue;
            ext = extension;
            break;
        }
        return ext;
    }

    public static enum MODES {
        RUN("run"),
        DEBUG("debug"),
        PROFILE("profile");

        private String mode;

        private MODES(String mode) {
            this.mode = mode;
        }

        public String getMode() {
            return this.mode;
        }
    }
}

