/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.infinitePanel;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class InfiniteProgressPanel {
    private static final String INFINITE_PANEL_KEY = "org.mihalis.opal.InfinitePanel.InfiniteProgressPanel";
    private static final int NUMBER_OF_STEPS = 10;
    private final Shell parent;
    private Shell panel;
    private String text;
    private Font textFont;
    private Color textColor;
    private float fps;
    private int barsCount;
    private int lineWidth;
    private int alpha;
    private Color defaultColor;
    private Color selectionColor;
    private int currentPosition;
    private Thread animatorThread;
    private Canvas canvas;
    private boolean fadeIn;
    private boolean fadeOut;
    private int fadeOutCounter;

    private InfiniteProgressPanel(Shell shell) {
        if (shell == null) {
            SWT.error((int)4);
        }
        if (shell.isDisposed()) {
            SWT.error((int)5);
        }
        this.parent = shell;
        if (shell.getData(INFINITE_PANEL_KEY) != null) {
            throw new IllegalArgumentException("This shell has already an infinite panel attached on it !");
        }
        this.text = null;
        this.textFont = null;
        this.barsCount = 14;
        this.fps = 15.0f;
        this.lineWidth = 16;
        this.alpha = 200;
        this.fadeIn = false;
        this.fadeOut = false;
        this.fadeOutCounter = 0;
        shell.setData(INFINITE_PANEL_KEY, (Object)this);
        this.parent.addListener(26, new Listener(){

            public void handleEvent(Event e) {
                if (InfiniteProgressPanel.this.panel != null && !InfiniteProgressPanel.this.panel.isDisposed() && !InfiniteProgressPanel.this.panel.isVisible()) {
                    InfiniteProgressPanel.this.panel.setVisible(true);
                    InfiniteProgressPanel.this.panel.setActive();
                }
            }
        });
    }

    public void start() {
        if (this.parent.isDisposed()) {
            SWT.error((int)24);
        }
        this.panel = new Shell(this.parent, 81928);
        this.panel.setLayout((Layout)new FillLayout());
        this.panel.setAlpha(0);
        this.panel.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
        if (this.defaultColor == null) {
            this.defaultColor = new Color((Device)this.parent.getDisplay(), 200, 200, 200);
        }
        if (this.selectionColor == null) {
            this.selectionColor = new Color((Device)this.parent.getDisplay(), 0, 0, 0);
        }
        this.parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTGraphicUtil.dispose((Resource)InfiniteProgressPanel.this.defaultColor);
                SWTGraphicUtil.dispose((Resource)InfiniteProgressPanel.this.selectionColor);
            }
        });
        this.currentPosition = 0;
        this.fadeIn = true;
        this.fadeOut = false;
        this.fadeOutCounter = 0;
        this.canvas = new Canvas((Composite)this.panel, 0x20040000);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                InfiniteProgressPanel.this.paintCanvas(e);
            }
        });
        this.panel.setBounds(this.panel.getDisplay().map((Control)this.parent, null, this.parent.getClientArea()));
        this.panel.open();
        this.animatorThread = new Thread(){

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    InfiniteProgressPanel.this.currentPosition = (InfiniteProgressPanel.this.currentPosition + 1) % InfiniteProgressPanel.this.barsCount;
                    if (InfiniteProgressPanel.this.fadeOut) {
                        InfiniteProgressPanel infiniteProgressPanel = InfiniteProgressPanel.this;
                        infiniteProgressPanel.fadeOutCounter = infiniteProgressPanel.fadeOutCounter + 1;
                    }
                    InfiniteProgressPanel.this.panel.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            InfiniteProgressPanel.this.canvas.redraw();
                        }
                    });
                    try {
                        5.sleep(InfiniteProgressPanel.this.fadeOut ? 20L : (long)(1000.0f / InfiniteProgressPanel.this.fps));
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
        };
        this.animatorThread.start();
        this.panel.addListener(27, new Listener(){

            public void handleEvent(Event arg0) {
                InfiniteProgressPanel.this.panel.setVisible(false);
            }
        });
    }

    private void paintCanvas(PaintEvent e) {
        Rectangle clientArea = ((Canvas)e.widget).getClientArea();
        GC gc = e.gc;
        this.handleFadeIn();
        this.handleFadeOut();
        this.drawBackground(clientArea, gc);
        this.drawTicker(clientArea, gc);
        this.drawText(clientArea, gc);
    }

    private void handleFadeIn() {
        if (this.fadeIn) {
            if (this.currentPosition == 10) {
                this.fadeIn = false;
                this.panel.setAlpha(this.alpha);
            } else {
                this.panel.setAlpha(this.currentPosition * this.alpha / 10);
            }
        }
    }

    private void handleFadeOut() {
        if (this.fadeOut) {
            if (this.fadeOutCounter == 10) {
                if (this.animatorThread != null) {
                    this.animatorThread.interrupt();
                    this.animatorThread = null;
                }
                if (!this.panel.isDisposed()) {
                    this.panel.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!InfiniteProgressPanel.this.panel.isDisposed()) {
                                InfiniteProgressPanel.this.panel.dispose();
                            }
                        }
                    });
                }
            }
            this.panel.setAlpha(255 - this.fadeOutCounter * this.alpha / 10);
        }
    }

    private void drawBackground(Rectangle clientArea, GC gc) {
        gc.setBackground(this.panel.getDisplay().getSystemColor(1));
        gc.fillRectangle(clientArea);
    }

    private void drawTicker(Rectangle clientArea, GC gc) {
        int centerX = clientArea.width / 2;
        int centerY = clientArea.height / 2;
        int maxRay = (int)((float)Math.min(clientArea.width, clientArea.height) * 0.6f) / 2;
        int minRay = (int)((float)maxRay * 0.5f);
        double angle = 1.5707963267948966;
        gc.setLineCap(2);
        gc.setLineWidth(this.lineWidth);
        gc.setAntialias(1);
        int i = 0;
        while (i < this.barsCount) {
            if (i == this.currentPosition) {
                gc.setForeground(this.selectionColor);
            } else {
                gc.setForeground(this.defaultColor);
            }
            gc.drawLine((int)((double)centerX + (double)minRay * Math.cos(angle)), (int)((double)centerY - (double)minRay * Math.sin(angle)), (int)((double)centerX + (double)maxRay * Math.cos(angle)), (int)((double)centerY - (double)maxRay * Math.sin(angle)));
            angle -= Math.PI * 2 / (double)this.barsCount;
            ++i;
        }
    }

    private void drawText(Rectangle clientArea, GC gc) {
        if (this.text == null || "".equals(this.text)) {
            return;
        }
        Font font = this.textFont == null ? this.parent.getDisplay().getSystemFont() : this.textFont;
        Color color = this.textColor == null ? this.parent.getDisplay().getSystemColor(2) : this.textColor;
        gc.setForeground(color);
        gc.setFont(font);
        gc.setTextAntialias(1);
        Point textSize = gc.textExtent(this.text, 1);
        int textWidth = textSize.x;
        int textHeight = textSize.y;
        gc.drawString(this.text, (clientArea.width - textWidth) / 2, (clientArea.height - textHeight) / 2, true);
    }

    public void stop() {
        if (this.panel.isDisposed() || this.panel.getDisplay().isDisposed()) {
            return;
        }
        this.fadeOut = true;
    }

    public static InfiniteProgressPanel getInfiniteProgressPanelFor(final Shell shell) {
        if (shell == null) {
            SWT.error((int)4);
        }
        if (shell.isDisposed()) {
            SWT.error((int)24);
        }
        if (shell.getDisplay().isDisposed()) {
            SWT.error((int)45);
        }
        final InfiniteProgressPanel[] temp = new InfiniteProgressPanel[1];
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Object data = shell.getData(InfiniteProgressPanel.INFINITE_PANEL_KEY);
                if (data != null && data instanceof InfiniteProgressPanel) {
                    temp[0] = (InfiniteProgressPanel)data;
                }
            }
        });
        if (temp[0] == null) {
            return new InfiniteProgressPanel(shell);
        }
        return temp[0];
    }

    public static boolean hasInfiniteProgressPanel(Shell shell) {
        return InfiniteProgressPanel.getInfiniteProgressPanelFor(shell) != null;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        if (alpha < 0 || alpha > 255) {
            SWT.error((int)5);
        }
        this.checkIfAnimationIsRunning();
        this.alpha = alpha;
    }

    private void checkIfAnimationIsRunning() {
        if (this.animatorThread != null) {
            SWT.error((int)5, null, (String)"Can not change this value when an animation is running");
        }
    }

    public int getBarsCount() {
        return this.barsCount;
    }

    public void setBarsCount(int barsCount) {
        this.checkIfAnimationIsRunning();
        this.barsCount = barsCount;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color defaultColor) {
        this.checkIfAnimationIsRunning();
        SWTGraphicUtil.dispose((Resource)this.defaultColor);
        this.defaultColor = defaultColor;
    }

    public float getFps() {
        return this.fps;
    }

    public void setFps(float fps) {
        this.checkIfAnimationIsRunning();
        this.fps = fps;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.checkIfAnimationIsRunning();
        this.lineWidth = lineWidth;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        this.checkIfAnimationIsRunning();
        SWTGraphicUtil.dispose((Resource)this.selectionColor);
        this.selectionColor = selectionColor;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.checkIfAnimationIsRunning();
        this.text = text;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.checkIfAnimationIsRunning();
        SWTGraphicUtil.dispose((Resource)this.textColor);
        this.textColor = textColor;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font textFont) {
        this.checkIfAnimationIsRunning();
        if (this.textFont != null && !this.textFont.isDisposed()) {
            this.textFont.dispose();
        }
        this.textFont = textFont;
    }
}

