/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.panels;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class DarkPanel {
    private final Shell parent;
    private static final String DARK_PANEL_KEY = "org.mihalis.opal.BluredPanel.DarkPanel";
    private int alpha;
    private Shell panel;
    private Canvas canvas;

    public DarkPanel(Shell shell) {
        if (shell == null) {
            SWT.error((int)4);
        }
        if (shell.isDisposed()) {
            SWT.error((int)5);
        }
        this.parent = shell;
        if (shell.getData(DARK_PANEL_KEY) != null) {
            throw new IllegalArgumentException("This shell has already an infinite panel attached on it !");
        }
        shell.setData(DARK_PANEL_KEY, (Object)this);
        this.alpha = 100;
    }

    public void show() {
        if (this.parent.isDisposed()) {
            SWT.error((int)24);
        }
        this.panel = new Shell(this.parent, 65544);
        this.panel.setLayout((Layout)new FillLayout());
        this.panel.setAlpha(this.alpha);
        this.panel.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
        this.canvas = new Canvas((Composite)this.panel, 0x20040000);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                DarkPanel.this.paintCanvas(e);
            }
        });
        this.panel.setBounds(this.panel.getDisplay().map((Control)this.parent, null, this.parent.getClientArea()));
        this.panel.open();
    }

    private void paintCanvas(PaintEvent e) {
        Rectangle clientArea = ((Canvas)e.widget).getClientArea();
        GC gc = e.gc;
        gc.setBackground(this.panel.getDisplay().getSystemColor(2));
        gc.fillRectangle(clientArea);
    }

    public void hide() {
        if (this.parent.isDisposed()) {
            SWT.error((int)24);
        }
        if (this.panel == null || this.panel.isDisposed()) {
            return;
        }
        this.panel.dispose();
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }
}

