/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.transitionComposite;

import org.eclipse.swt.widgets.Control;
import org.mihalis.opal.transitionComposite.Transition;

abstract class VerticalTransition
implements Transition {
    VerticalTransition() {
    }

    @Override
    public void performTransition(final Control first, final Control second) {
        if (first.isDisposed() || second.isDisposed()) {
            return;
        }
        final int[] currentPosition = new int[]{0};
        final int maxValue = first.getParent().getClientArea().height;
        first.setBounds(0, 0, first.getBounds().width, first.getBounds().height);
        second.setBounds(0, -1 * second.getBounds().width, second.getBounds().width, second.getBounds().height);
        first.moveAbove(second);
        second.setVisible(true);
        if (first.isDisposed() || first.getDisplay().isDisposed()) {
            return;
        }
        first.getDisplay().timerExec(0, new Runnable(){

            @Override
            public void run() {
                if (first.isDisposed() || second.isDisposed()) {
                    return;
                }
                currentPosition[0] = currentPosition[0] + 10;
                if (currentPosition[0] > maxValue) {
                    first.setVisible(false);
                    second.setBounds(0, 0, first.getBounds().width, first.getBounds().height);
                    return;
                }
                first.setBounds(0, VerticalTransition.this.getCoeff() * currentPosition[0], first.getBounds().width, first.getBounds().height);
                if (VerticalTransition.this.secondIsBehind()) {
                    second.setBounds(0, -1 * VerticalTransition.this.getCoeff() * (maxValue - currentPosition[0]), second.getBounds().width, second.getBounds().height);
                }
                if (!first.isDisposed() && !first.getDisplay().isDisposed()) {
                    first.getDisplay().timerExec(15, (Runnable)this);
                }
            }
        });
    }

    protected abstract int getCoeff();

    protected abstract boolean secondIsBehind();
}

