/*
 * Decompiled with CFR 0.152.
 */
package zipeditor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.IWorkbenchAdapter;
import zipeditor.Messages;
import zipeditor.MultiElementPropertyPage;
import zipeditor.ZipEditorPlugin;

public class MultiPreferenceDialog
extends PreferenceDialog {
    private IAdaptable[] fElements;
    private MultiElementPropertyPage fPropertyPage;

    public MultiPreferenceDialog(Shell parentShell, PreferenceManager manager, IAdaptable[] elements) {
        super(parentShell, manager);
        this.fElements = elements;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.createText());
        this.selectPropertyPage();
    }

    private void selectPropertyPage() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.propertyPages").getExtensions();
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].getContributor().getName().equals("org.tizen.common.externals")) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    String objectClass = elements[j].getAttribute("objectClass");
                    if (objectClass != null) {
                        try {
                            Class clazz = Platform.getBundle((String)elements[j].getContributor().getName()).loadClass(objectClass);
                            if (this.fElements != null && this.fElements.length > 0 && this.fElements[0].getClass().isAssignableFrom(clazz)) {
                                this.fPropertyPage = (MultiElementPropertyPage)((Object)elements[j].createExecutableExtension("class"));
                                this.fPropertyPage.setElements(this.fElements);
                                this.fPropertyPage.setTitle(elements[j].getAttribute("name"));
                                this.getPreferenceManager().addToRoot((IPreferenceNode)new PreferenceNode(new String(), (IPreferencePage)this.fPropertyPage));
                                break;
                            }
                        }
                        catch (Exception e) {
                            ZipEditorPlugin.log(e);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private String createText() {
        if (this.fElements != null) {
            if (this.fElements.length == 1) {
                String s = ((IWorkbenchAdapter)this.fElements[0].getAdapter(IWorkbenchAdapter.class)).getLabel((Object)this.fElements[0]);
                return Messages.getFormattedString("MultiPreferenceDialog.0", s);
            }
            return Messages.getFormattedString("MultiPreferenceDialog.1", new Integer(this.fElements.length));
        }
        return Messages.getFormattedString("MultiPreferenceDialog.0", null);
    }
}

