/*
 * Decompiled with CFR 0.152.
 */
package zipeditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import zipeditor.ZipEditorPlugin;
import zipeditor.model.Node;
import zipeditor.model.ZipContentDescriber;
import zipeditor.model.ZipModel;

public class ZipContentProvider
implements ITreeContentProvider {
    private int fMode = 2;
    private Map fModels = new HashMap();
    private boolean fDisposeModel = true;

    public ZipContentProvider() {
    }

    public ZipContentProvider(int mode) {
        this.fMode = mode;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Node) {
            return this.getNodeChildren((Node)((Object)parentElement));
        }
        if (parentElement instanceof IFile) {
            return this.getFileChildren((IFile)parentElement);
        }
        return new Object[0];
    }

    private Object[] getNodeChildren(Node node) {
        this.fModels.put(null, node.getModel());
        if ((this.fMode & 2) > 0) {
            return node.getChildren();
        }
        ArrayList result = new ArrayList();
        this.addChildren(result, node, 0);
        return result.toArray();
    }

    private void addChildren(List list, Node node, int depth) {
        Node[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            boolean foldersVisible;
            Node child = children[i];
            this.addChildren(list, child, depth + 1);
            boolean bl = foldersVisible = (this.fMode & 4) > 0;
            if (foldersVisible || !child.isFolder()) {
                boolean allInOneLayer;
                boolean bl2 = allInOneLayer = (this.fMode & 8) > 0;
                if (depth == 0 || allInOneLayer) {
                    list.add(child);
                }
            }
            ++i;
        }
    }

    private Object[] getFileChildren(IFile file) {
        if (!ZipContentProvider.isForUs(file)) {
            return new Object[0];
        }
        try {
            ZipModel model = this.getModel(file);
            while (model.isInitializing()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            return this.getNodeChildren(model.getRoot());
        }
        catch (CoreException e) {
            ZipEditorPlugin.log((Object)e);
            return new Object[0];
        }
    }

    private ZipModel getModel(IFile file) throws CoreException {
        return new ZipModel(file.getLocation().toFile(), file.getContents(), file.isReadOnly());
    }

    public Object getParent(Object element) {
        return element instanceof Node ? ((Node)((Object)element)).getParent() : null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IFile) {
            return ZipContentProvider.isForUs((IFile)element);
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.disposeModels();
    }

    private void disposeModels() {
        if (this.fModels != null) {
            for (ZipModel model : this.fModels.values()) {
                if (!this.fDisposeModel) continue;
                model.dispose();
            }
            this.fModels.clear();
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput == null) {
            this.disposeModels();
        }
    }

    public static boolean isForUs(IFile file) {
        IContentDescription contentDescription;
        block5: {
            block4: {
                try {
                    contentDescription = file.getContentDescription();
                    if (contentDescription != null) break block4;
                    return false;
                }
                catch (CoreException e) {
                    ZipEditorPlugin.log((Object)e);
                    return false;
                }
            }
            if (contentDescription.getContentType() != null) break block5;
            return false;
        }
        String contentTypeId = contentDescription.getContentType().getId();
        return ZipContentDescriber.isForUs(contentTypeId);
    }

    public void disposeModel(boolean enable) {
        this.fDisposeModel = enable;
    }
}

