/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.actions;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import zipeditor.actions.ExtractAction;
import zipeditor.actions.MultiPropertyDialogAction;
import zipeditor.actions.OpenActionGroup;
import zipeditor.actions.ViewerAction;

public class ZipActionProvider
extends CommonActionProvider {
    private OpenActionGroup fOpenActionGroup;
    private ViewerAction fExtractAction;
    private IAction fPropertiesAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.fOpenActionGroup = new OpenActionGroup(aSite.getStructuredViewer(), true);
        this.fExtractAction = new ExtractAction(aSite.getStructuredViewer());
    }

    public void dispose() {
        super.dispose();
        this.fOpenActionGroup.dispose();
    }

    public void fillContextMenu(IMenuManager menu) {
        this.fOpenActionGroup.setContext(this.getContext());
        this.fOpenActionGroup.fillContextMenu(menu);
        menu.appendToGroup("additions", (IContributionItem)new Separator());
        menu.appendToGroup("additions", (IAction)this.fExtractAction);
        menu.appendToGroup("additions", (IContributionItem)new Separator());
        if (this.fPropertiesAction == null) {
            this.fPropertiesAction = new MultiPropertyDialogAction((IShellProvider)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), this.getActionSite().getViewSite().getSelectionProvider());
        }
        if (!this.hasProperties(menu)) {
            menu.appendToGroup("additions", this.fPropertiesAction);
        }
    }

    private boolean hasProperties(IMenuManager menu) {
        IContributionItem[] items = menu.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof ActionContributionItem && ActionFactory.PROPERTIES.getCommandId().equals(((ActionContributionItem)items[i]).getAction().getActionDefinitionId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void fillActionBars(IActionBars actionBars) {
        this.fOpenActionGroup.setContext(this.getContext());
        this.fOpenActionGroup.fillActionBars(actionBars);
    }
}

