/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.ui.model.IWorkbenchAdapter;
import zipeditor.model.NodeWorkbenchAdapter;
import zipeditor.model.ZipModel;

public class Node
extends PlatformObject {
    protected Node parent;
    protected List children;
    protected int state;
    protected String name;
    protected long time;
    protected long size;
    protected File file;
    private byte[] content;
    protected ZipModel model;
    private String path;
    private String fullPath;
    private Hashtable property;
    private static final int FOLDER = 1;
    private static final int MODIFIED = 2;
    private static final int ADDED = 4;

    public Node(ZipModel model, String name, boolean isFolder) {
        if (model == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        this.model = model;
        this.name = name;
        this.state |= isFolder ? 1 : 0;
        this.time = System.currentTimeMillis();
    }

    public Node getParent() {
        return this.parent;
    }

    public ZipModel getModel() {
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.equals(this.name)) {
            return;
        }
        this.name = name;
        this.resetPathCache();
        this.state |= 2;
        this.model.setDirty(true);
        this.model.notifyListeners();
    }

    public String getPath() {
        if (this.path == null) {
            if (this.parent == null) {
                this.path = new String();
            } else {
                StringBuffer sb = new StringBuffer(this.parent.getPath());
                if (this.isFolder()) {
                    sb.append(this.name);
                    sb.append('/');
                }
                this.path = sb.toString();
            }
        }
        return this.path;
    }

    public String getFullPath() {
        if (this.fullPath == null) {
            StringBuffer sb = new StringBuffer(this.getPath());
            if (!this.isFolder()) {
                sb.append(this.name);
            }
            this.fullPath = sb.toString();
        }
        return this.fullPath;
    }

    public String getType() {
        int index = this.name.lastIndexOf(46);
        return index != -1 ? this.name.substring(index + 1) : "";
    }

    public boolean isFolder() {
        return (this.state & 1) > 0;
    }

    public boolean isModified() {
        return (this.state & 2) > 0;
    }

    public boolean isAdded() {
        return (this.state & 4) > 0;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        if (time == this.time) {
            return;
        }
        this.time = time;
        this.state |= 2;
        this.model.setDirty(true);
        this.model.notifyListeners();
    }

    public long getSize() {
        return this.size;
    }

    protected void setSize(long size) {
        this.size = size;
    }

    public Node[] getChildren() {
        return this.children != null ? this.children.toArray(new Node[this.children.size()]) : new Node[]{};
    }

    public Node getChildByName(String name, boolean deep) {
        Node child;
        if (this.children == null) {
            return null;
        }
        int i = 0;
        int n = this.children.size();
        while (i < n) {
            child = (Node)((Object)this.children.get(i));
            if (child.name.equals(name)) {
                return child;
            }
            ++i;
        }
        if (!deep) {
            return null;
        }
        i = 0;
        n = this.children.size();
        while (i < n) {
            child = (Node)((Object)this.children.get(i));
            Node result = child.getChildByName(name, deep);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public Object getProperty(Object key) {
        if (this.property == null) {
            return null;
        }
        return this.property.get(key);
    }

    public void setProperty(Object key, Object value) {
        if (this.property == null) {
            this.property = new Hashtable();
        }
        this.property.put(key, value);
    }

    public InputStream getContent() {
        try {
            return this.doGetContent();
        }
        catch (Exception e) {
            this.model.logError(e);
            return null;
        }
    }

    protected InputStream doGetContent() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        return null;
    }

    protected void setContent(byte[] buf) {
        this.content = buf;
    }

    private void internalAdd(Node node, int atIndex) {
        node.parent = this;
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if (atIndex < 0) {
            atIndex = this.children.size();
        }
        this.children.add(atIndex, node);
        this.model.setDirty(true);
        this.model.notifyListeners();
        node.resetPathCache();
    }

    public void add(Node node, Node beforeSibling) {
        this.internalAdd(node, this.children != null && beforeSibling != null ? this.children.indexOf((Object)beforeSibling) : -1);
    }

    public void add(File file, Node beforeSibling, IProgressMonitor monitor) {
        Node node = this.create(this.model, file.getName(), file.isDirectory());
        this.add(node, beforeSibling);
        node.state |= 4;
        if (node.isFolder()) {
            node.time = file.lastModified();
            File[] files = file.listFiles();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    if (monitor.isCanceled()) break;
                    monitor.subTask(files[i].getName());
                    node.add(files[i], null, monitor);
                    ++i;
                }
            }
            node.state |= 2;
        } else {
            node.updateContent(file);
            monitor.worked(1);
        }
    }

    public void updateContent(File file) {
        this.file = file;
        this.time = file.lastModified();
        this.size = file.length();
        this.state |= 2;
        this.model.setDirty(true);
        this.model.notifyListeners();
    }

    public void update(Object entry) {
    }

    public void remove(Node node) {
        if (this.children == null) {
            return;
        }
        this.children.remove((Object)node);
        this.model.setDirty(true);
        this.model.notifyListeners();
        node.clear();
    }

    private void clear() {
        if (this.children != null) {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                ((Node)((Object)it.next())).clear();
                it.remove();
            }
            this.children = null;
        }
    }

    public void reset() {
        this.model.deleteFile(this.file);
        this.file = null;
        this.state &= 0xFFFFFFFD;
        this.model.notifyListeners();
    }

    private void resetPathCache() {
        this.fullPath = null;
        this.path = null;
        if (this.children != null) {
            int i = 0;
            while (i < this.children.size()) {
                ((Node)((Object)this.children.get(i))).resetPathCache();
                ++i;
            }
        }
    }

    public Node create(ZipModel model, String name, boolean isFolder) {
        return new Node(model, name, isFolder);
    }

    public String toString() {
        return this.getFullPath();
    }

    public Object getAdapter(Class adapter) {
        if (Node.class == adapter) {
            return this;
        }
        if (IWorkbenchAdapter.class == adapter) {
            return new NodeWorkbenchAdapter(this);
        }
        return super.getAdapter(adapter);
    }
}

