/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.operations;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.progress.UIJob;
import zipeditor.Messages;
import zipeditor.Utils;
import zipeditor.ZipEditorPlugin;
import zipeditor.model.Node;

public class AddOperation {
    public void execute(String[] fileNames, Node parentNode, Node beforeSibling, StructuredViewer viewer) {
        while (parentNode != null && !parentNode.isFolder()) {
            parentNode = parentNode.getParent();
        }
        AddFilesJob addFilesJob = new AddFilesJob(fileNames, parentNode, beforeSibling, new RefreshJob(viewer));
        addFilesJob.schedule();
    }

    private File[] getFilesFromNames(String[] filesNames) {
        File[] files = new File[filesNames.length];
        int i = 0;
        while (i < files.length) {
            files[i] = new File(filesNames[i]);
            ++i;
        }
        return files;
    }

    private class AddFilesJob
    extends Job {
        private String[] fFilesNames;
        private Node fParentNode;
        private Node fBeforeSibling;
        private boolean fAtLeastOneAdded;
        private UIJob fRefreshJob;

        public AddFilesJob(String[] filesNames, Node parentNode, Node beforeSibling, UIJob refreshJob) {
            super(Messages.getString("AddOperation.1"));
            this.fFilesNames = filesNames;
            this.fParentNode = parentNode;
            this.fBeforeSibling = beforeSibling;
            this.fRefreshJob = refreshJob;
        }

        public IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.getString("AddOperation.4"), 100);
            monitor.worked(1);
            int totalWork = Utils.computeTotalNumber(AddOperation.this.getFilesFromNames(this.fFilesNames), monitor);
            monitor.setTaskName(Messages.getString("AddOperation.2"));
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 99);
            subMonitor.beginTask(Messages.getString("AddOperation.2"), totalWork);
            try {
                boolean oneAdded = false;
                int i = 0;
                while (i < this.fFilesNames.length) {
                    if (subMonitor.isCanceled()) break;
                    try {
                        this.fParentNode.add(new File(this.fFilesNames[i]), this.fBeforeSibling, (IProgressMonitor)subMonitor);
                        oneAdded = true;
                    }
                    catch (Exception e) {
                        IStatus iStatus = ZipEditorPlugin.createErrorStatus(Messages.getString("AddOperation.0"), e);
                        subMonitor.done();
                        monitor.done();
                        return iStatus;
                    }
                    subMonitor.worked(1);
                    ++i;
                }
                if (oneAdded) {
                    this.fRefreshJob.schedule();
                }
            }
            finally {
                subMonitor.done();
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public boolean atLeastOneAdded() {
            return this.fAtLeastOneAdded;
        }
    }

    private class RefreshJob
    extends UIJob {
        private StructuredViewer fViewer;

        public RefreshJob(StructuredViewer viewer) {
            super(Messages.getString("AddOperation.3"));
            this.fViewer = viewer;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!this.fViewer.getControl().isDisposed()) {
                this.fViewer.refresh();
            }
            return Status.OK_STATUS;
        }
    }
}

