/*
* Web IDE - Command Line Interface
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact:
* GyeongSeok Seo <gyeongseok.seo@samsung.com>
* Jihoon Song <jihoon80.song@samsung.com>
* BonYong Lee <bonyong.lee@samsung.com>
* Hyeongseok Heo <hyeongseok.heo@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.cli.exec.gen;

import java.io.File;
import java.text.MessageFormat;

import static org.tizen.cli.exec.LaunchOptionConstants.OPT_NAME;
import static org.tizen.cli.exec.LaunchOptionConstants.OPT_PATH;
import static org.tizen.cli.exec.LaunchOptionConstants.DESC_NAME;
import static org.tizen.cli.exec.LaunchOptionConstants.DESC_PATH;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.tizen.cli.exec.AbstractLauncher;
import org.tizen.cli.exec.Help;
import org.tizen.common.core.command.Prompter;
import org.tizen.common.core.command.prompter.ChoiceOption;
import org.tizen.common.core.command.prompter.Option;
import org.tizen.common.util.ObjectUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.web.project.wizard.cli.command.ProjectGenCommand;

/**
 * Command Line Interface for install widget in target
 * 
 * @author GyeongSeok Seo{@literal <gyeongseok.seo@samsung.com>} (S-Core)
 * @author Jihoon Song{@literal <jihoon80.song@samsung.com>} (S-Core)
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * @author Hyeongseok Heo{@literal <hyeongseok.heo@samsung.com>} (S-Core)
 */
public class
Main
extends AbstractLauncher
{


	/**
	 * Entry point for cli main
	 * 
	 * @param args user input parameter
	 * 
	 * @throws Exception If unhandled exception occur
	 */
	public static
	void
	main (
		final String[] args
	)
	throws Exception
	{
		final Main instance = new Main();
		instance.run( args );
	}

	@Override
	protected
	void
	execute(
		CommandLine cmdLine
	)
	throws Exception
	{
		final Prompter prompter = getPrompter();

		logger.trace( "create ProjectGenCommand instance" );
		ProjectGenCommand command = new ProjectGenCommand();

		logger.trace( "get user input options" );
		String name = cmdLine.getOptionValue( OPT_NAME );
		String path = cmdLine.getOptionValue( OPT_PATH );

		logger.trace( "set user input options" );
		command.setProjectName( name );
		command.setTargetPath( new File(StringUtil.isEmpty(path) ? "." : path).getAbsolutePath() );

		logger.trace( "check destination directory" );
		String destDir = command.getDestDir();
		if ( command.isDirectoryExists( destDir ) ) {
			ChoiceOption yes = new ChoiceOption( "Yes", true );
			ChoiceOption no = new ChoiceOption( "No" );

			final Option option = prompter.interact(
				MessageFormat.format( "{0} is already exist\nDo you want to be overwrite and continue [Y/n]? ", destDir ),
				yes,
				no
			);

			if ( no.equals( option ) )
			{
				prompter.notify( "Process is canceled." );
				return ;
			}
		}

		logger.trace( "execute project gen command" );
		getExecutor().execute( command );

		logger.trace( "check excute result" );
		String result = command.getResult();
		if ( ObjectUtil.equals("Success", result) ) {
			command.printInfo(prompter);
		}
		prompter.notify( result + "." );
	}

	/* (non-Javadoc)
	 * @see org.tizen.cli.exec.AbstractLauncher#getOptions()
	 */
	@Override
    @SuppressWarnings("static-access")
	protected
	Options
	getOptions()
	{
		final Options opts = super.getOptions();
		opts.addOption( OptionBuilder.hasArg().withLongOpt( OPT_NAME ).withDescription( DESC_NAME ).create( OPT_NAME.substring( 0, 1 ) ) );
		opts.addOption( OptionBuilder.hasArg().withLongOpt( OPT_PATH ).withDescription( DESC_PATH ).create( OPT_PATH.substring( 0, 1 ) ) );
		return opts;
	}

	/* (non-Javadoc)
	 * @see org.tizen.cli.exec.AbstractLauncher#createHelp()
	 */
	@Override
	protected Help createHelp() {
		Help help = super.createHelp();

		help.setSyntax( help.getSyntax() + getSyntax() );
		return help;
	}

	/* (non-Javadoc)
	 * @see org.tizen.cli.exec.AbstractLauncher#getSyntax()
	 */
	@Override
	protected
	String
	getSyntax()
	{
		return " [options]";
	}
}
