/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.explorer;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.connection.explorer.ConnectionUIMessages;
import org.tizen.common.connection.explorer.RemoteDeviceManagerDeviceItem;
import org.tizen.common.connection.explorer.RemoteDeviceManagerDialog;
import org.tizen.common.util.OSChecker;

public class RemoteDeviceManagerSubDialog
extends Dialog {
    private Shell shell = null;
    private Text nameText = null;
    private Text ipText = null;
    private Text portText = null;
    private String name = "";
    private String ip = "";
    private String port = "26101";
    private RemoteDeviceManagerDialog parentDialog = null;
    private boolean isAddOperation = true;
    private String title = ConnectionUIMessages.Remote_Device_Manager_Lbl_Edit;

    public RemoteDeviceManagerSubDialog(Shell parentShell, RemoteDeviceManagerDialog parentDialog, boolean isAddOperation) {
        super(parentShell);
        this.shell = parentShell;
        this.parentDialog = parentDialog;
        this.isAddOperation = isAddOperation;
        if (isAddOperation) {
            this.title = ConnectionUIMessages.Remote_Device_Manager_Lbl_Add;
            return;
        }
        if (parentDialog.selectedItem == null || parentDialog.selectedItem.isDisposed()) {
            return;
        }
        RemoteDeviceManagerDeviceItem selectItem = (RemoteDeviceManagerDeviceItem)parentDialog.selectedItem.getData();
        this.name = selectItem.getName();
        this.ip = selectItem.getIP();
        this.port = selectItem.getPort();
    }

    public boolean open() {
        this.shell = new Shell(this.shell, 67680);
        Rectangle parentBounds = this.getParent().getBounds();
        this.shell.setLocation(parentBounds.x + this.getParent().getBounds().width / 5, parentBounds.y + this.getParent().getBounds().height / 5);
        this.createUI(this.shell);
        this.shell.pack();
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return true;
    }

    private void createUI(Shell shell) {
        shell.setText(this.title);
        shell.setLayout((Layout)new GridLayout(1, false));
        Group mid = new Group((Composite)shell, 4);
        mid.setText(ConnectionUIMessages.Remote_Device_Manager_Lbl_Input);
        mid.setLayoutData((Object)new GridData(1808));
        mid.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)mid, 0);
        label.setText(ConnectionUIMessages.Remote_Device_Manager_Lbl_Name);
        this.nameText = new Text((Composite)mid, 2052);
        this.nameText.setText(this.name);
        this.nameText.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)mid, 0);
        label.setText(ConnectionUIMessages.Remote_Device_Manager_Lbl_IP);
        this.ipText = new Text((Composite)mid, 2052);
        this.ipText.setText(this.ip);
        this.ipText.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)mid, 0);
        label.setText(ConnectionUIMessages.Remote_Device_Manager_Lbl_Port);
        this.portText = new Text((Composite)mid, 2052);
        this.portText.setText(this.port);
        this.portText.setLayoutData((Object)new GridData(768));
        Composite bottomComp = new Composite((Composite)shell, 0);
        GridLayout compLayout = new GridLayout(2, false);
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 3;
        bottomComp.setLayoutData((Object)gd);
        compLayout.marginRight = 8;
        compLayout.horizontalSpacing = 12;
        bottomComp.setLayout((Layout)compLayout);
        Button firstButton = null;
        Button seconderButton = null;
        if (OSChecker.isWindows()) {
            firstButton = this.createOKButton(bottomComp);
            seconderButton = this.createCloseButton(bottomComp);
        } else {
            firstButton = this.createCloseButton(bottomComp);
            seconderButton = this.createOKButton(bottomComp);
        }
        gd = new GridData();
        gd.horizontalAlignment = 3;
        gd.widthHint = 60;
        firstButton.setLayoutData((Object)gd);
        gd = new GridData();
        gd.widthHint = 60;
        gd.horizontalAlignment = 3;
        gd.grabExcessHorizontalSpace = true;
        seconderButton.setLayoutData((Object)gd);
    }

    private Button createOKButton(Composite container) {
        Button okButton = new Button(container, 0);
        if (this.isAddOperation) {
            okButton.setText(ConnectionUIMessages.Remote_Device_Manager_Btn_Add);
        } else {
            okButton.setText(ConnectionUIMessages.Remote_Device_Manager_Btn_Save);
        }
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = RemoteDeviceManagerSubDialog.this.nameText.getText();
                String ip = RemoteDeviceManagerSubDialog.this.ipText.getText();
                String port = RemoteDeviceManagerSubDialog.this.portText.getText();
                boolean isSuccess = false;
                isSuccess = RemoteDeviceManagerSubDialog.this.isAddOperation ? RemoteDeviceManagerSubDialog.this.parentDialog.addDeviceInfo(name, ip, port) : RemoteDeviceManagerSubDialog.this.parentDialog.modifyDeviceInfo(name, ip, port);
                if (isSuccess) {
                    RemoteDeviceManagerSubDialog.this.shell.close();
                }
            }
        });
        okButton.setFocus();
        okButton.setDefault(true);
        return okButton;
    }

    private Button createCloseButton(Composite container) {
        Button cancelButton = new Button(container, 0);
        cancelButton.setText(ConnectionUIMessages.Remote_Device_Manager_Btn_Cancel);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteDeviceManagerSubDialog.this.shell.close();
            }
        });
        return cancelButton;
    }
}

