/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.util;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.ui.RestImageRegistry;
import org.tizen.common.rest.ui.dialogs.PrefVariableAddDialog;
import org.tizen.common.rest.util.StringUtil;
import org.tizen.common.rest.util.VariableNameProcessor;
import org.tizen.common.util.SWTUtil;

public class AddVariableCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension4 {
    private static Image proposalImage = RestImageRegistry.IMG_DESC_VARIABLE_ADD.createImage();
    private VariableNameProcessor processor;

    public AddVariableCompletionProposal(VariableNameProcessor processor) {
        this.processor = processor;
    }

    public void apply(IDocument document) {
        String[] result = this.openAddPopup();
        if (result != null && result.length == 2) {
            this.processor.updateProposal();
            String origin = document.get();
            try {
                document.replace(0, origin.length(), "${" + result[0] + "}");
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    private String[] openAddPopup() {
        PrefVariableAddDialog dialog = new PrefVariableAddDialog(SWTUtil.getShell());
        String[] result = (String[])dialog.open();
        if (result != null && result.length == 2) {
            if (!this.isExistKey(result[0])) {
                this.saveToPreference(result);
            } else {
                MessageDialog.openError((Shell)SWTUtil.getShell(), (String)"Variable exist", (String)("Key '" + result[0] + "' is already exist!"));
            }
        }
        return result;
    }

    private boolean isExistKey(String key) {
        return StringUtil.getActiveProfileVariablesMap().containsKey(key);
    }

    private void saveToPreference(String[] result) {
        String vars = StringUtil.getActiveProfileVariables();
        vars = String.valueOf(vars) + result[0] + "=" + result[1] + "|";
        IPreferenceStore prefStore = RestPlugin.getDefault().getPreferenceStore();
        String profile = StringUtil.getActiveProfileVariablesKey();
        prefStore.setValue("PREF_KEY_USER_VARIABLES." + profile, vars);
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return RestUIMessages.AddVariableCompletionProposal_additional_string;
    }

    public String getDisplayString() {
        return RestUIMessages.AddVariableCompletionProposal_disp_string;
    }

    public Image getImage() {
        return proposalImage;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public boolean isAutoInsertable() {
        return false;
    }
}

