/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.receiver;

import java.util.ArrayList;
import java.util.List;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.receiver.PsInfo;
import org.tizen.sdblib.util.ArrayUtil;
import org.tizen.sdblib.util.StringUtil;

public class PsReceiver
extends MultiLineReceiver {
    private static final String DELIMITER = " ";
    private String[] keys = null;
    private List<PsInfo> psInfos = new ArrayList<PsInfo>();

    @Override
    public void processNewLines(String[] lines) {
        this.generatePsInfos(lines);
    }

    private void generatePsInfos(String[] lines) {
        int startLine = 0;
        if (ArrayUtil.isEmpty(this.keys)) {
            this.keys = StringUtil.split(lines[startLine], DELIMITER);
            ++startLine;
        }
        int i = startLine;
        while (i < lines.length) {
            PsInfo psInfo = this.createPsInfo(lines[i], this.keys);
            if (psInfo != null) {
                this.add(psInfo);
            }
            ++i;
        }
    }

    private void add(PsInfo psInfo) {
        this.psInfos.add(psInfo);
    }

    private PsInfo createPsInfo(String line, String[] keys) {
        PsInfo psInfo = new PsInfo();
        String[] values = StringUtil.split(line, DELIMITER);
        if (keys.length > values.length) {
            return null;
        }
        int i = 0;
        while (i < keys.length) {
            StringBuffer value = new StringBuffer();
            if (i == keys.length - 1) {
                int j = i;
                while (j < values.length) {
                    value.append(values[j]);
                    ++j;
                }
            } else {
                value.append(values[i]);
            }
            psInfo.set(keys[i], value.toString());
            ++i;
        }
        return psInfo;
    }

    public PsInfo[] getPsInfos() {
        return this.psInfos.toArray(new PsInfo[0]);
    }

    public PsInfo[] getPsInfos(String key, String value) {
        ArrayList<PsInfo> psInfos = new ArrayList<PsInfo>();
        PsInfo[] psInfoArray = this.getPsInfos();
        int n = psInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            PsInfo psInfo = psInfoArray[n2];
            if (psInfo.get(key).equals(value)) {
                psInfos.add(psInfo);
            }
            ++n2;
        }
        return psInfos.toArray(new PsInfo[0]);
    }

    public void clear() {
        this.keys = null;
        this.psInfos.clear();
    }
}

