/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.brushedMetalComposite;

import java.util.Random;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class BrushedMetalComposite
extends Composite {
    private Image oldImage;
    private int radius = 10;
    private float amount = 0.1f;
    private int color = -7829368;
    private float shine = 0.1f;
    private boolean monochrome = true;
    private Random randomNumbers;

    public BrushedMetalComposite(Composite parent, int style) {
        super(parent, style);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                BrushedMetalComposite.this.redrawComposite();
            }
        });
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTGraphicUtil.dispose((Resource)BrushedMetalComposite.this.oldImage);
            }
        });
    }

    private void redrawComposite() {
        Display display = this.getDisplay();
        Rectangle rect = this.getClientArea();
        ImageData imageData = this.drawBrushedMetalBackground(Math.max(1, rect.width), Math.max(1, rect.width));
        Image newImage = new Image((Device)display, imageData);
        this.setBackgroundImage(newImage);
        SWTGraphicUtil.dispose((Resource)this.oldImage);
        this.oldImage = newImage;
    }

    private ImageData drawBrushedMetalBackground(int width, int height) {
        int[] inPixels = new int[width];
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        ImageData data = new ImageData(width, height, 32, palette);
        this.randomNumbers = new Random(0L);
        int a = this.color & 0xFF000000;
        int r = this.color >> 16 & 0xFF;
        int g = this.color >> 8 & 0xFF;
        int b = this.color & 0xFF;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int tr = r;
                int tg = g;
                int tb = b;
                if (this.shine != 0.0f) {
                    int f = (int)((double)(255.0f * this.shine) * Math.sin((double)x / (double)width * Math.PI));
                    tr += f;
                    tg += f;
                    tb += f;
                }
                if (this.monochrome) {
                    int n = (int)(255.0f * (2.0f * this.randomNumbers.nextFloat() - 1.0f) * this.amount);
                    inPixels[x] = a | this.clamp(tr + n) << 16 | this.clamp(tg + n) << 8 | this.clamp(tb + n);
                } else {
                    inPixels[x] = a | this.random(tr) << 16 | this.random(tg) << 8 | this.random(tb);
                }
                ++x;
            }
            if (this.radius != 0) {
                this.setDataElements(data, palette, 0, y, width, 1, this.blur(inPixels, width, this.radius));
            } else {
                this.setDataElements(data, palette, 0, y, width, 1, inPixels);
            }
            ++y;
        }
        return data;
    }

    private void setDataElements(ImageData data, PaletteData palette, int posX, int posY, int width, int height, int[] pixels) {
        int cpt = 0;
        int y = posY;
        while (y < posY + height) {
            int x = posX;
            while (x < posX + width) {
                int rgb = pixels[cpt++];
                int pixel = palette.getPixel(new RGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF));
                data.setPixel(x, y, pixel);
                data.setAlpha(x, y, rgb >> 24 & 0xFF);
                ++x;
            }
            ++y;
        }
    }

    private int random(int x) {
        if ((x += (int)(255.0f * (2.0f * this.randomNumbers.nextFloat() - 1.0f) * this.amount)) < 0) {
            x = 0;
        } else if (x > 255) {
            x = 255;
        }
        return x;
    }

    private int clamp(int c) {
        if (c < 0) {
            return 0;
        }
        if (c > 255) {
            return 255;
        }
        return c;
    }

    private int[] blur(int[] in, int width, int radius) {
        int[] out = new int[width];
        int widthMinus1 = width - 1;
        int r2 = 2 * radius + 1;
        int tr = 0;
        int tg = 0;
        int tb = 0;
        int i = -radius;
        while (i <= radius) {
            int rgb = in[this.mod(i, width)];
            tr += rgb >> 16 & 0xFF;
            tg += rgb >> 8 & 0xFF;
            tb += rgb & 0xFF;
            ++i;
        }
        int x = 0;
        while (x < width) {
            int i2;
            out[x] = 0xFF000000 | tr / r2 << 16 | tg / r2 << 8 | tb / r2;
            int i1 = x + radius + 1;
            if (i1 > widthMinus1) {
                i1 = this.mod(i1, width);
            }
            if ((i2 = x - radius) < 0) {
                i2 = this.mod(i2, width);
            }
            int rgb1 = in[i1];
            int rgb2 = in[i2];
            tr += (rgb1 & 0xFF0000) - (rgb2 & 0xFF0000) >> 16;
            tg += (rgb1 & 0xFF00) - (rgb2 & 0xFF00) >> 8;
            tb += (rgb1 & 0xFF) - (rgb2 & 0xFF);
            ++x;
        }
        return out;
    }

    private int mod(int a, int b) {
        int n;
        if ((a -= (n = a / b) * b) < 0) {
            return a + b;
        }
        return a;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.redrawComposite();
    }

    public float getAmount() {
        return this.amount;
    }

    public void setAmount(float amount) {
        if (amount < 0.0f || amount > 1.0f) {
            SWT.error((int)5);
        }
        this.amount = amount;
        this.redrawComposite();
    }

    public Color getColor() {
        return new Color((Device)this.getDisplay(), this.color >> 16 & 0xFF, this.color >> 8 & 0xFF, this.color & 0xFF);
    }

    public void setColor(Color color) {
        if (color == null) {
            SWT.error((int)4);
        }
        this.color = 0xFF000000 | color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        this.redrawComposite();
    }

    public float getShine() {
        return this.shine;
    }

    public void setShine(float shine) {
        if (this.amount < 0.0f || this.amount > 1.0f) {
            SWT.error((int)5);
        }
        this.shine = shine;
        this.redrawComposite();
    }

    public boolean isMonochrome() {
        return this.monochrome;
    }

    public void setMonochrome(boolean monochrome) {
        this.monochrome = monochrome;
        this.redrawComposite();
    }
}

