/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.flatButton;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class FlatButton
extends Canvas {
    private Image image;
    private String text;
    private boolean selection;
    private int alignment;
    private final List<SelectionListener> listeners = new ArrayList<SelectionListener>();
    private boolean mouseIn;
    private Color backgroundColor;
    private Color selectedColor;
    private Color selectedTextColor;
    private Color mouseOverColor;

    public FlatButton(Composite parent, int style) {
        super(parent, style);
        this.buildAlignmentFromStyle(style);
        this.addListeners();
        this.initializeDefaultColors();
    }

    private void buildAlignmentFromStyle(int style) {
        this.alignment = (style & 0x4000) == 16384 ? 16384 : ((style & 0x20000) == 131072 ? 131072 : 0x1000000);
    }

    private void addListeners() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                FlatButton.this.paintControl(e);
            }
        });
        this.addListener(6, new Listener(){

            public void handleEvent(Event event) {
                FlatButton.this.mouseIn = true;
                FlatButton.this.redraw();
            }
        });
        this.addListener(7, new Listener(){

            public void handleEvent(Event event) {
                FlatButton.this.mouseIn = false;
                FlatButton.this.redraw();
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                boolean doIt = true;
                FlatButton.this.selection = !FlatButton.this.selection;
                for (SelectionListener listener : FlatButton.this.listeners) {
                    SelectionEvent sEvent = new SelectionEvent(event);
                    listener.widgetSelected(sEvent);
                    boolean bl = doIt = doIt && sEvent.doit;
                }
                if (!doIt) {
                    FlatButton.this.selection = !FlatButton.this.selection;
                }
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 64: {
                        event.doit = true;
                        FlatButton.this.traverseButton(true, event);
                        break;
                    }
                    case 32: {
                        event.doit = true;
                        FlatButton.this.traverseButton(false, event);
                    }
                }
            }
        });
    }

    private void traverseButton(boolean next, Event event) {
        Control[] childrens = this.getParent().getChildren();
        ArrayList<Control> list = new ArrayList<Control>();
        Control[] controlArray = childrens;
        int n = childrens.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof FlatButton && !child.isDisposed()) {
                list.add(child);
            }
            ++n2;
        }
        int indexOf = list.indexOf((Object)this);
        if (indexOf == -1) {
            return;
        }
        indexOf = next ? (indexOf > list.size() - 2 ? indexOf : indexOf + 1) : (indexOf < 1 ? indexOf : indexOf - 1);
        Control chosenCtrl = (Control)list.get(indexOf);
        chosenCtrl.notifyListeners(4, event);
        chosenCtrl.setFocus();
    }

    private void initializeDefaultColors() {
        this.backgroundColor = this.getDisplay().getSystemColor(1);
        this.selectedColor = new Color((Device)this.getDisplay(), 0, 112, 192);
        this.selectedTextColor = this.getDisplay().getSystemColor(1);
        this.mouseOverColor = new Color((Device)this.getDisplay(), 235, 234, 226);
        SWTGraphicUtil.dispose((Control)this, (Resource)this.selectedColor);
        SWTGraphicUtil.dispose((Control)this, (Resource)this.mouseOverColor);
        SWTGraphicUtil.dispose((Control)this, (Resource)this.image);
    }

    private void paintControl(PaintEvent e) {
        GC gc = e.gc;
        this.drawBackground(gc);
        if (this.image != null) {
            this.drawImage(gc);
        }
        if (this.text != null) {
            this.drawText(gc);
        }
    }

    private void drawBackground(GC gc) {
        Color color = this.selection ? this.selectedColor : (this.mouseIn ? this.mouseOverColor : this.backgroundColor);
        gc.setBackground(color);
        gc.fillRectangle(this.getClientArea());
    }

    private void drawImage(GC gc) {
        Rectangle rect = this.getClientArea();
        Point imageSize = new Point(this.image.getBounds().width, this.image.getBounds().height);
        int x = this.alignment == 16384 ? 5 : (this.alignment == 131072 ? rect.width - imageSize.x - 5 : (rect.width - imageSize.x) / 2);
        gc.drawImage(this.image, x, 5);
    }

    private void drawText(GC gc) {
        Rectangle rect = this.getClientArea();
        if (this.selection) {
            gc.setForeground(this.selectedTextColor);
        } else {
            gc.setForeground(this.getForeground());
        }
        gc.setFont(this.getFont());
        Point textSize = gc.stringExtent(this.text);
        int x = this.alignment == 16384 ? 5 : (this.alignment == 131072 ? rect.width - textSize.x - 5 : (rect.width - textSize.x) / 2);
        int y = this.image == null ? 5 : 10 + this.image.getBounds().height;
        gc.drawString(this.text, x, y, true);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.listeners.add(listener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = 10;
        int height = 15;
        if (this.image != null) {
            Rectangle bounds = this.image.getBounds();
            width += bounds.width;
            height += bounds.height;
        }
        if (this.text != null) {
            GC gc = new GC((Drawable)this);
            Point extent = gc.stringExtent(this.text);
            gc.dispose();
            width = Math.max(width, extent.x + 10);
            height += extent.y;
        }
        return new Point(Math.max(width, wHint), Math.max(height, hHint));
    }

    public int getAlignment() {
        this.checkWidget();
        return this.alignment;
    }

    public Color getBackgroundColor() {
        this.checkWidget();
        return this.backgroundColor;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Color getMouseOverColor() {
        this.checkWidget();
        return this.mouseOverColor;
    }

    public Color getSelectedColor() {
        this.checkWidget();
        return this.selectedColor;
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public boolean getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.listeners.remove(listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.alignment = alignment;
        this.redraw();
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.checkWidget();
        this.backgroundColor = backgroundColor;
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.image = image;
        this.redraw();
    }

    public void setMouseOverColor(Color mouseOverColor) {
        this.checkWidget();
        this.mouseOverColor = mouseOverColor;
    }

    public void setSelectedColor(Color selectedColor) {
        this.checkWidget();
        this.selectedColor = selectedColor;
    }

    public void setSelectedTextColor(Color selectedTextColor) {
        this.selectedTextColor = selectedTextColor;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        this.selection = selected;
        this.redraw();
    }

    public void setText(String text) {
        this.checkWidget();
        this.text = text;
        this.redraw();
    }
}

