/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.login;

import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.mihalis.opal.login.LoginDialogVerifier;
import org.mihalis.opal.opalDialog.Dialog;
import org.mihalis.opal.utils.ResourceManager;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class LoginDialog {
    private Image image;
    private String description;
    private String login;
    private String password;
    private List<String> autorizedLogin;
    private boolean displayRememberPassword = true;
    private boolean rememberPassword;
    private LoginDialogVerifier verifier;
    private Shell shell;
    private boolean returnedValue;
    private Button buttonOk;

    public boolean open() {
        if (this.verifier == null) {
            throw new IllegalArgumentException("Please set a verifier before opening the dialog box");
        }
        this.buildDialog();
        this.openShell();
        return this.returnedValue;
    }

    private void buildDialog() {
        this.buildShell();
        this.buildImage();
        this.buildDescription();
        this.buildLogin();
        this.buildPassword();
        if (this.displayRememberPassword) {
            this.buildRememberPassword();
        }
        this.buildButtons();
    }

    private void buildShell() {
        this.shell = new Shell(133152);
        this.shell.setText(ResourceManager.getLabel("login"));
        this.shell.setLayout((Layout)new GridLayout(4, false));
    }

    private void buildImage() {
        Canvas canvas = new Canvas((Composite)this.shell, 0x20000000);
        GridData gridData = new GridData(4, 4, true, false, 4, 1);
        gridData.widthHint = 400;
        gridData.heightHint = 60;
        canvas.setLayoutData((Object)gridData);
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawImage(LoginDialog.this.image == null ? LoginDialog.this.createDefaultImage(e.width, e.height) : LoginDialog.this.image, 0, 0);
            }
        });
    }

    private Image createDefaultImage(int w, int h) {
        Display display = Display.getCurrent();
        Color backgroundColor = new Color((Device)display, 49, 121, 242);
        Color gradientColor1 = new Color((Device)display, 155, 185, 245);
        Color gradientColor2 = new Color((Device)display, 53, 123, 242);
        Image img = new Image((Device)display, w, h);
        GC gc = new GC((Drawable)img);
        gc.setAdvanced(true);
        gc.setAntialias(1);
        gc.setBackground(backgroundColor);
        gc.fillRectangle(0, 0, w, h);
        Path curveShape = new Path((Device)display);
        curveShape.moveTo(0.0f, (float)h * 0.6f);
        curveShape.cubicTo((float)w * 0.167f, (float)h * 1.2f, (float)w * 0.667f, (float)h * -0.5f, (float)w, (float)h * 0.75f);
        curveShape.lineTo((float)w, (float)h);
        curveShape.lineTo(0.0f, (float)h);
        curveShape.lineTo(0.0f, (float)h * 0.8f);
        curveShape.close();
        Pattern pattern = new Pattern((Device)display, 0.0f, 0.0f, 1.0f, (float)h * 1.2f, gradientColor1, gradientColor2);
        gc.setBackgroundPattern(pattern);
        gc.fillPath(curveShape);
        Font font = new Font((Device)display, "Arial Bold", 30, 0);
        gc.setFont(font);
        gc.setForeground(display.getSystemColor(1));
        Point textSize = gc.stringExtent(ResourceManager.getLabel("login"));
        gc.drawString(ResourceManager.getLabel("login"), (int)((float)w * 0.05f), (h - textSize.y) / 2, true);
        font.dispose();
        curveShape.dispose();
        pattern.dispose();
        backgroundColor.dispose();
        gradientColor1.dispose();
        gradientColor2.dispose();
        gc.dispose();
        return img;
    }

    private void buildDescription() {
        Label label = new Label((Composite)this.shell, 0);
        GridData gridData = new GridData(4, 1, true, false, 4, 1);
        gridData.verticalIndent = 5;
        gridData.horizontalIndent = 5;
        label.setLayoutData((Object)gridData);
        final Font bold = SWTGraphicUtil.buildFontFrom((Control)label, 1);
        label.setFont(bold);
        label.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SWTGraphicUtil.dispose((Resource)bold);
            }
        });
        if (this.description == null || this.description.trim().equals("")) {
            label.setText(" ");
        } else {
            label.setText(this.description);
        }
    }

    private void buildLogin() {
        Label label = new Label((Composite)this.shell, 0);
        GridData gridData = new GridData(3, 3, false, false, 1, 1);
        gridData.horizontalIndent = 35;
        gridData.verticalIndent = 15;
        label.setLayoutData((Object)gridData);
        label.setText(ResourceManager.getLabel("name"));
        if (this.autorizedLogin != null && !this.autorizedLogin.isEmpty()) {
            final Combo combo = new Combo((Composite)this.shell, 2056);
            combo.setLayoutData((Object)new GridData(4, 3, true, false, 3, 1));
            for (String loginToAdd : this.autorizedLogin) {
                combo.add(loginToAdd);
            }
            combo.setText(this.login == null ? "" : this.login);
            combo.setFocus();
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LoginDialog.this.login = combo.getText();
                    LoginDialog.this.changeButtonOkState();
                }
            });
        } else {
            final Text text = new Text((Composite)this.shell, 2048);
            text.setText(this.login == null ? "" : this.login);
            text.setLayoutData((Object)new GridData(4, 3, true, false, 3, 1));
            text.setFocus();
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LoginDialog.this.login = text.getText();
                    LoginDialog.this.changeButtonOkState();
                }
            });
        }
    }

    private void buildPassword() {
        Label label = new Label((Composite)this.shell, 0);
        GridData gridData = new GridData(3, 2, false, false, 1, 1);
        gridData.horizontalIndent = 35;
        label.setLayoutData((Object)gridData);
        label.setText(ResourceManager.getLabel("password"));
        final Text text = new Text((Composite)this.shell, 0x400800);
        text.setText(this.password == null ? "" : this.password);
        text.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoginDialog.this.password = text.getText();
                LoginDialog.this.changeButtonOkState();
            }
        });
    }

    private void changeButtonOkState() {
        boolean loginEntered = this.login != null && !this.login.trim().equals("");
        boolean passwordEntered = this.password != null && !this.password.trim().equals("");
        this.buttonOk.setEnabled(loginEntered && passwordEntered);
    }

    private void buildRememberPassword() {
        Button checkbox = new Button((Composite)this.shell, 32);
        GridData gridData = new GridData(1, 2, true, false, 4, 1);
        gridData.horizontalIndent = 35;
        checkbox.setLayoutData((Object)gridData);
        checkbox.setText(ResourceManager.getLabel("rememberPassword"));
        checkbox.setSelection(this.rememberPassword);
    }

    private void buildButtons() {
        this.buttonOk = new Button((Composite)this.shell, 8);
        GridData gdOk = new GridData(3, 2, true, false, 3, 1);
        gdOk.verticalIndent = 60;
        gdOk.minimumWidth = 80;
        this.buttonOk.setLayoutData((Object)gdOk);
        this.buttonOk.setText(ResourceManager.getLabel("Ok"));
        this.buttonOk.setEnabled(false);
        this.buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * Unable to fully structure code
             */
            public void widgetSelected(SelectionEvent selectionEvent) {
                block4: {
                    try {
                        LoginDialog.access$5(LoginDialog.this).authenticate(LoginDialog.access$6(LoginDialog.this), LoginDialog.access$7(LoginDialog.this));
                        LoginDialog.access$8(LoginDialog.this, true);
                        LoginDialog.access$9(LoginDialog.this).dispose();
                        break block4;
                    }
                    catch (Exception e) {
                        Dialog.error(ResourceManager.getLabel("loginFailed"), e.getMessage());
                        var6_3 = LoginDialog.access$9(LoginDialog.this).getChildren();
                        var5_4 = var6_3.length;
                        var4_5 = 0;
                        ** while (var4_5 < var5_4)
                    }
lbl-1000:
                    // 1 sources

                    {
                        control = var6_3[var4_5];
                        if (control instanceof Text || control instanceof Combo) {
                            control.setFocus();
                            break;
                        }
                        ++var4_5;
                        continue;
                    }
                }
            }
        });
        Button buttonCancel = new Button((Composite)this.shell, 8);
        GridData gdCancel = new GridData(4, 2, false, false);
        gdCancel.widthHint = 80;
        gdCancel.verticalIndent = 60;
        buttonCancel.setLayoutData((Object)gdCancel);
        buttonCancel.setText(ResourceManager.getLabel("Cancel"));
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoginDialog.this.returnedValue = false;
                LoginDialog.this.shell.dispose();
            }
        });
    }

    private void openShell() {
        this.shell.setDefaultButton(this.buttonOk);
        this.shell.pack();
        this.shell.open();
        SWTGraphicUtil.centerShell(this.shell);
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    public Image getImage() {
        return this.image;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLogin() {
        return this.login == null ? null : this.login.trim();
    }

    public String getPassword() {
        return this.password == null ? null : this.password.trim();
    }

    public List<String> getAutorizedLogin() {
        return this.autorizedLogin;
    }

    public boolean isDisplayRememberPassword() {
        return this.displayRememberPassword;
    }

    public boolean isRememberPassword() {
        return this.rememberPassword;
    }

    public LoginDialogVerifier getVerifier() {
        return this.verifier;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAutorizedLogin(List<String> autorizedLogin) {
        this.autorizedLogin = autorizedLogin;
    }

    public void setAutorizedLogin(String ... autorizedLogin) {
        this.autorizedLogin = Arrays.asList(autorizedLogin);
    }

    public void setDisplayRememberPassword(boolean displayRememberPassword) {
        this.displayRememberPassword = displayRememberPassword;
    }

    public void setRememberPassword(boolean rememberPassword) {
        this.rememberPassword = rememberPassword;
    }

    public void setVerifier(LoginDialogVerifier verifier) {
        this.verifier = verifier;
    }

    static /* synthetic */ LoginDialogVerifier access$5(LoginDialog loginDialog) {
        return loginDialog.verifier;
    }

    static /* synthetic */ String access$6(LoginDialog loginDialog) {
        return loginDialog.login;
    }

    static /* synthetic */ String access$7(LoginDialog loginDialog) {
        return loginDialog.password;
    }
}

