/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.opalDialog;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.mihalis.opal.opalDialog.ChoiceItem;
import org.mihalis.opal.opalDialog.ChoiceWidget;
import org.mihalis.opal.opalDialog.Dialog;
import org.mihalis.opal.opalDialog.DialogArea;
import org.mihalis.opal.utils.SWTGraphicUtil;
import org.mihalis.opal.utils.StringUtil;

public class MessageArea
extends DialogArea {
    private Composite composite;
    private String title;
    private Image icon;
    private String text;
    private int radioChoice = -1;
    private int radioDefaultSelection;
    private String[] radioValues;
    private Throwable exception;
    private Text textException;
    private String textBoxValue;
    private int choice = -1;
    private int choiceDefaultSelection;
    private ChoiceItem[] choiceValues;
    private ProgressBar progressBar;
    private int progressBarMinimumValue;
    private int progressBarMaximumValue;
    private int progressBarValue = -1;

    public MessageArea(Dialog parent) {
        super(parent);
    }

    public MessageArea addChoice(int defaultSelection, ChoiceItem ... items) {
        this.setInitialised(true);
        this.choiceDefaultSelection = defaultSelection;
        this.choiceValues = items;
        return this;
    }

    public MessageArea addRadioButtons(int defaultSelection, String ... values) {
        this.setInitialised(true);
        this.radioDefaultSelection = defaultSelection;
        this.radioValues = values;
        return this;
    }

    public MessageArea addTextBox(String value) {
        this.setInitialised(true);
        this.textBoxValue = value;
        return this;
    }

    public MessageArea addProgressBar(int mininum, int maximum, int value) {
        this.setInitialised(true);
        this.progressBarMinimumValue = mininum;
        this.progressBarMaximumValue = maximum;
        this.progressBarValue = value;
        return this;
    }

    @Override
    public void render() {
        int numberOfRows;
        if (!this.isInitialised()) {
            return;
        }
        this.composite = new Composite((Composite)this.parent.shell, 0);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.composite.setBackground(this.composite.getDisplay().getSystemColor(1));
        boolean hasIcon = this.icon != null;
        boolean hasTitle = !StringUtil.isEmpty(this.title);
        boolean hasText = !StringUtil.isEmpty(this.text);
        boolean hasRadio = this.radioValues != null;
        boolean hasException = this.exception != null;
        boolean hasTextbox = this.textBoxValue != null;
        boolean hasChoice = this.choiceValues != null;
        boolean hasProgressBar = this.progressBarValue != -1;
        int numberOfColumns = hasIcon ? 2 : 1;
        int n = numberOfRows = hasTitle && hasText ? 2 : 1;
        if (hasRadio) {
            numberOfRows += this.radioValues.length;
        }
        if (hasChoice) {
            numberOfRows += this.choiceValues.length;
        }
        if (hasException || hasTextbox) {
            ++numberOfRows;
        }
        if (hasProgressBar) {
            ++numberOfRows;
        }
        GridLayout gridLayout = new GridLayout(numberOfColumns, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginRight = 10;
        gridLayout.marginLeft = 10;
        gridLayout.marginTop = 10;
        gridLayout.marginBottom = 10;
        this.composite.setLayout((Layout)gridLayout);
        if (hasIcon) {
            this.createIcon(numberOfRows);
        }
        if (hasTitle) {
            this.createTitle(hasIcon);
        }
        if (hasText) {
            this.createText(hasIcon, hasTitle);
        }
        if (hasRadio) {
            this.createRadioButtons();
        }
        if (hasException) {
            this.createTextException();
        }
        if (hasTextbox) {
            this.createTextBox();
        }
        if (hasChoice) {
            this.createChoice();
        }
        if (hasProgressBar) {
            this.createProgressBar();
        }
    }

    private void createIcon(int numberOfRows) {
        Label label = new Label(this.composite, 0);
        label.setImage(this.icon);
        label.setBackground(this.composite.getDisplay().getSystemColor(1));
        label.setLayoutData((Object)new GridData(2, 1, false, false, 1, numberOfRows));
    }

    private void createTitle(boolean hasIcon) {
        Label label = new Label(this.composite, 0);
        label.setText(this.title);
        label.setFont(this.getBiggerFont());
        label.setForeground(this.getTitleColor());
        label.setBackground(Display.getCurrent().getSystemColor(1));
        GridData gd = new GridData(1, 1, false, false, 1, 1);
        if (hasIcon) {
            gd.horizontalIndent = 8;
        } else {
            gd.horizontalIndent = 10;
            gd.verticalIndent = 10;
        }
        label.setLayoutData((Object)gd);
    }

    private void createText(boolean hasIcon, boolean hasTitle) {
        StyledText label = new StyledText(this.composite, 0);
        label.setText("<html><body>" + this.text + "</body></html>");
        SWTGraphicUtil.applyHTMLFormating(label);
        label.setEnabled(false);
        label.setBackground(Display.getCurrent().getSystemColor(1));
        GridData gd = new GridData(1, 1, false, false, 1, 1);
        if (hasIcon) {
            gd.horizontalIndent = 8;
        } else {
            gd.horizontalIndent = 20;
            gd.verticalIndent = hasTitle ? 8 : 20;
        }
        label.setLayoutData((Object)gd);
    }

    private void createRadioButtons() {
        int i = 0;
        while (i < this.radioValues.length) {
            final Button button = new Button(this.composite, 16);
            button.setBackground(Display.getCurrent().getSystemColor(1));
            button.setText(this.radioValues[i]);
            final Integer index = new Integer(i);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (button.getSelection()) {
                        MessageArea.this.radioChoice = index;
                    }
                }
            });
            button.setSelection(i == this.radioDefaultSelection);
            GridData gd = new GridData(1, 1, false, false, 1, 1);
            gd.horizontalIndent = 10;
            button.setLayoutData((Object)gd);
            ++i;
        }
    }

    private void createTextException() {
        this.textException = new Text(this.composite, 2826);
        this.textException.setText(StringUtil.stackStraceAsString(this.exception));
        this.textException.setBackground(Display.getCurrent().getSystemColor(1));
        GridData gd = new GridData(4, 4, false, false, 1, 1);
        gd.minimumHeight = 300;
        this.textException.setLayoutData((Object)gd);
    }

    private void createTextBox() {
        final Text textbox = new Text(this.composite, 2052);
        textbox.setText(this.textBoxValue);
        textbox.setBackground(Display.getCurrent().getSystemColor(1));
        GridData gd = new GridData(4, 4, true, false, 1, 1);
        textbox.setLayoutData((Object)gd);
        textbox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MessageArea.this.textBoxValue = textbox.getText();
            }
        });
    }

    private void createChoice() {
        int i = 0;
        while (i < this.choiceValues.length) {
            ChoiceWidget choice = new ChoiceWidget(this.composite, 16);
            choice.setBackground(Display.getCurrent().getSystemColor(1));
            choice.setChoiceItem(this.choiceValues[i]);
            final Integer index = new Integer(i);
            choice.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MessageArea.this.choice = index;
                    MessageArea.this.parent.shell.dispose();
                }
            });
            choice.setSelection(i == this.choiceDefaultSelection);
            GridData gd = new GridData(4, 4, false, false, 1, 1);
            choice.setLayoutData(gd);
            ++i;
        }
    }

    private void createProgressBar() {
        this.progressBar = new ProgressBar(this.composite, 65792);
        this.progressBar.setMinimum(this.progressBarMinimumValue);
        this.progressBar.setMaximum(this.progressBarMaximumValue);
        this.progressBar.setSelection(this.progressBarValue);
        this.progressBar.setBackground(Display.getCurrent().getSystemColor(1));
        GridData gd = new GridData(4, 4, true, false, 1, 1);
        this.progressBar.setLayoutData((Object)gd);
    }

    void hideException() {
        this.textException.dispose();
        this.parent.pack();
    }

    void showException() {
        this.createTextException();
        this.parent.pack();
    }

    public String getTitle() {
        return this.title;
    }

    public MessageArea setTitle(String title) {
        this.title = title;
        this.setInitialised(true);
        return this;
    }

    public Image getIcon() {
        return this.icon;
    }

    public MessageArea setIcon(Image icon) {
        this.icon = icon;
        this.setInitialised(true);
        return this;
    }

    public String getText() {
        return this.text;
    }

    public MessageArea setText(String text) {
        this.text = text;
        this.setInitialised(true);
        return this;
    }

    public int getRadioChoice() {
        return this.radioChoice;
    }

    public Throwable getException() {
        return this.exception;
    }

    public MessageArea setException(Throwable exception) {
        this.exception = exception;
        this.setInitialised(true);
        return this;
    }

    public int getChoice() {
        return this.choice;
    }

    public String getTextBoxValue() {
        return this.textBoxValue;
    }

    public int getProgressBarMinimumValue() {
        return this.progressBarMinimumValue;
    }

    public void setProgressBarMinimumValue(int progressBarMinimumValue) {
        this.progressBarMinimumValue = progressBarMinimumValue;
        if (this.progressBar != null && !this.progressBar.isDisposed()) {
            this.progressBar.setMinimum(progressBarMinimumValue);
        }
    }

    public int getProgressBarMaximumValue() {
        return this.progressBarMaximumValue;
    }

    public void setProgressBarMaximumValue(int progressBarMaximumValue) {
        this.progressBarMaximumValue = progressBarMaximumValue;
        if (this.progressBar != null && !this.progressBar.isDisposed()) {
            this.progressBar.setMaximum(progressBarMaximumValue);
        }
    }

    public int getProgressBarValue() {
        return this.progressBarValue;
    }

    public void setProgressBarValue(int progressBarValue) {
        this.progressBarValue = progressBarValue;
        if (this.progressBar != null && !this.progressBar.isDisposed()) {
            this.progressBar.setSelection(progressBarValue);
        }
    }
}

