/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.preferenceWindow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.mihalis.opal.preferenceWindow.PWRowGroup;
import org.mihalis.opal.preferenceWindow.PWTab;
import org.mihalis.opal.preferenceWindow.PWTabContainer;
import org.mihalis.opal.preferenceWindow.ValueAndAssociatedWidgets;
import org.mihalis.opal.preferenceWindow.widgets.PWWidget;
import org.mihalis.opal.utils.ResourceManager;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class PreferenceWindow {
    private final Map<String, ValueAndAssociatedWidgets> values;
    private final List<PWTab> tabs;
    private final Shell parentShell;
    private boolean returnedValue;
    private Shell shell;
    private static PreferenceWindow instance;

    private PreferenceWindow(Shell parent, Map<String, Object> values) {
        this.parentShell = parent;
        this.values = new HashMap<String, ValueAndAssociatedWidgets>(values.size());
        for (String key : values.keySet()) {
            this.values.put(key, new ValueAndAssociatedWidgets(values.get(key)));
        }
        this.tabs = new ArrayList<PWTab>();
    }

    public static PreferenceWindow create(Shell parent, Map<String, Object> values) {
        instance = new PreferenceWindow(parent, values);
        return instance;
    }

    public static PreferenceWindow create(Map<String, Object> values) {
        instance = new PreferenceWindow(null, values);
        return instance;
    }

    public static PreferenceWindow getInstance() {
        if (instance == null) {
            throw new NullPointerException("The instance of PreferenceWindow has not yet been created or has been destroyed.");
        }
        return instance;
    }

    public PWTab addTab(Image image, String text) {
        PWTab tab = new PWTab(image, text);
        this.tabs.add(tab);
        return tab;
    }

    public void addWidgetLinkedTo(String propertyKey, PWWidget widget) {
        if (!this.values.containsKey(propertyKey)) {
            this.values.put(propertyKey, new ValueAndAssociatedWidgets(null));
        }
        this.values.get(propertyKey).addWidget(widget);
    }

    public void addRowGroupLinkedTo(String propertyKey, PWRowGroup rowGroup) {
        if (!this.values.containsKey(propertyKey)) {
            this.values.put(propertyKey, new ValueAndAssociatedWidgets(null));
        }
        this.values.get(propertyKey).addRowGroup(rowGroup);
    }

    public boolean open() {
        this.shell = this.parentShell == null ? new Shell(1264) : new Shell(PreferenceWindow.instance.parentShell, 1264);
        this.shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                instance = null;
            }
        });
        this.buildShell();
        this.openShell();
        return this.returnedValue;
    }

    private void buildShell() {
        this.shell.setText(ResourceManager.getLabel("preferences"));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.shell.setLayout((Layout)gridLayout);
        PWTabContainer container = new PWTabContainer((Composite)this.shell, 0, this.tabs);
        container.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        container.build();
        Label sep = new Label((Composite)this.shell, 258);
        sep.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.buildButtons();
    }

    public void buildTabs(Composite parent) {
        this.buildTabs(parent, null);
    }

    public void buildTabs(Composite parent, Color selectedTabColor) {
        PWTabContainer container = new PWTabContainer(parent, 2048, this.tabs);
        container.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        container.build(selectedTabColor);
    }

    private void buildButtons() {
        Button buttonOK = new Button((Composite)this.shell, 8);
        buttonOK.setText(ResourceManager.getLabel("Ok"));
        GridData gridDataOk = new GridData(3, 3, true, false);
        gridDataOk.widthHint = 100;
        buttonOK.setLayoutData((Object)gridDataOk);
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceWindow.this.returnedValue = true;
                PreferenceWindow.this.shell.dispose();
            }
        });
        this.shell.setDefaultButton(buttonOK);
        Button buttonCancel = new Button((Composite)this.shell, 8);
        buttonCancel.setText(ResourceManager.getLabel("Cancel"));
        GridData gridDataCancel = new GridData(1, 3, false, false);
        gridDataCancel.widthHint = 100;
        buttonCancel.setLayoutData((Object)gridDataCancel);
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceWindow.this.returnedValue = false;
                PreferenceWindow.this.shell.dispose();
            }
        });
    }

    private void openShell() {
        this.shell.pack();
        this.shell.open();
        SWTGraphicUtil.centerShell(this.shell);
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    public void fireEnablers() {
        for (String key : this.values.keySet()) {
            this.values.get(key).fireValueChanged();
        }
    }

    public Object getValueFor(String key) {
        if (this.values.containsKey(key)) {
            return this.values.get(key).getValue();
        }
        return null;
    }

    public Map<String, Object> getValues() {
        HashMap<String, Object> returnedValues = new HashMap<String, Object>();
        for (String key : this.values.keySet()) {
            returnedValues.put(key, this.values.get(key).getValue());
        }
        return returnedValues;
    }

    public void setValue(String key, Object value) {
        if (this.values.containsKey(key)) {
            this.values.get(key).setValue(value);
        } else {
            this.values.put(key, new ValueAndAssociatedWidgets(value));
        }
    }
}

