/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.titledSeparator;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class TitledSeparator
extends Composite {
    private int alignment = 16384;
    private Image image;
    private String text;

    public TitledSeparator(Composite parent, int style) {
        super(parent, style);
        Font originalFont;
        final Color originalColor = new Color((Device)this.getDisplay(), 0, 88, 150);
        this.setForeground(originalColor);
        FontData[] fontData = this.getFont().getFontData();
        if (fontData != null && fontData.length > 0) {
            FontData fd = fontData[0];
            fd.setStyle(1);
            originalFont = new Font((Device)this.getDisplay(), fd);
            this.setFont(originalFont);
        } else {
            originalFont = null;
        }
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                TitledSeparator.this.redrawComposite();
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SWTGraphicUtil.dispose((Resource)originalColor);
                SWTGraphicUtil.dispose((Resource)originalFont);
            }
        });
    }

    private void redrawComposite() {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        int numberOfColumns = 1;
        if (this.text != null) {
            ++numberOfColumns;
        }
        if (this.image != null) {
            ++numberOfColumns;
        }
        if (this.alignment == 0x1000000) {
            ++numberOfColumns;
        }
        super.setLayout((Layout)new GridLayout(numberOfColumns, false));
        this.createContent();
    }

    private void createContent() {
        switch (this.alignment) {
            case 0x1000000: {
                this.createSeparator();
                this.createTitle();
                break;
            }
            case 16384: {
                this.createTitle();
                this.createSeparator();
                break;
            }
            default: {
                this.createSeparator();
                this.createTitle();
            }
        }
    }

    private void createSeparator() {
        Label separator = new Label((Composite)this, 258);
        separator.setLayoutData((Object)new GridData(4, 2, true, false));
        separator.setBackground(this.getBackground());
    }

    private void createTitle() {
        if (this.image != null) {
            Label imageLabel = this.createLabel();
            imageLabel.setImage(this.image);
        }
        if (this.text != null && !this.text.trim().equals("")) {
            Label textLabel = this.createLabel();
            textLabel.setText(this.text);
        }
    }

    private Label createLabel() {
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(4, 2, false, false));
        label.setFont(this.getFont());
        label.setForeground(this.getForeground());
        label.setBackground(this.getBackground());
        return label;
    }

    public void setLayout(Layout layout) {
        throw new UnsupportedOperationException("Not supported");
    }

    public int getAlignment() {
        this.checkWidget();
        return this.alignment;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        this.alignment = alignment;
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.image = image;
    }

    public void setText(String text) {
        this.checkWidget();
        this.text = text;
    }
}

