/*
 * Decompiled with CFR 0.152.
 */
package zipeditor;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.framelist.Frame;
import zipeditor.model.Node;
import zipeditor.model.ZipModel;

public class TableFrame
extends Frame {
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_ELEMENT = "element";
    private static final String TAG_FRAME_INPUT = "frameInput";
    private static final String TAG_PATH = "nodePath";
    private TableViewer fViewer;
    private Object fInput;
    private ISelection fSelection;

    public TableFrame(TableViewer viewer) {
        this.fViewer = viewer;
    }

    public TableFrame(TableViewer viewer, Object input) {
        this(viewer);
        this.setInput(input);
        ILabelProvider provider = (ILabelProvider)viewer.getLabelProvider();
        String name = provider.getText(input);
        if (name == null) {
            name = "";
        }
        this.setName(name);
        this.setToolTipText(name);
    }

    public Object getInput() {
        return this.fInput;
    }

    public ISelection getSelection() {
        return this.fSelection;
    }

    public TableViewer getViewer() {
        return this.fViewer;
    }

    public void restoreState(IMemento memento, ZipModel model) {
        IMemento selectionMem;
        String inputPath;
        IMemento inputMem = memento.getChild(TAG_FRAME_INPUT);
        String string = inputPath = inputMem != null ? inputMem.getString(TAG_PATH) : null;
        if (inputPath != null) {
            this.fInput = model.findNode(inputPath);
        }
        if ((selectionMem = memento.getChild(TAG_SELECTION)) != null) {
            IMemento[] elements = selectionMem.getChildren(TAG_ELEMENT);
            ArrayList<Node> selection = new ArrayList<Node>();
            int i = 0;
            while (i < elements.length) {
                Node node;
                String nodePath = elements[i].getString(TAG_PATH);
                if (nodePath != null && (node = model.findNode(nodePath)) != null) {
                    selection.add(node);
                }
                ++i;
            }
            this.fSelection = new StructuredSelection(selection);
        } else {
            this.fSelection = StructuredSelection.EMPTY;
        }
    }

    private void saveNode(Node node, IMemento memento, String childTag) {
        IMemento childMem = memento.createChild(childTag);
        childMem.putString(TAG_PATH, node.getFullPath());
    }

    public void saveState(IMemento memento) {
        Object[] elements;
        if (this.fInput instanceof Node) {
            this.saveNode((Node)((Object)this.fInput), memento, TAG_FRAME_INPUT);
        }
        if (this.fSelection instanceof IStructuredSelection && (elements = ((IStructuredSelection)this.fSelection).toArray()).length > 0) {
            IMemento selectionMem = memento.createChild(TAG_SELECTION);
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof Node) {
                    this.saveNode((Node)((Object)elements[i]), selectionMem, TAG_ELEMENT);
                }
                ++i;
            }
        }
    }

    public void setInput(Object input) {
        this.fInput = input;
    }

    public void setSelection(ISelection selection) {
        this.fSelection = selection;
    }
}

