/*
 * Decompiled with CFR 0.152.
 */
package zipeditor;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import zipeditor.ZipEditorPlugin;
import zipeditor.ZipLabelProvider;
import zipeditor.model.Node;
import zipeditor.model.ZipNode;

public class ZipSorter
extends ViewerSorter {
    private int fSortBy;
    private int fSortDirection;
    private boolean fSortEnabled;
    private int fMode;
    private String fPreferencePrefix;

    public ZipSorter() {
        this("commonNavigator");
    }

    public ZipSorter(String preferencePrefix) {
        this.fPreferencePrefix = preferencePrefix;
        this.update();
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (!this.fSortEnabled) {
            return 0;
        }
        if (e1 instanceof Node && e2 instanceof Node) {
            return this.compareNodes((Node)((Object)e1), (Node)((Object)e2));
        }
        return super.compare(viewer, e1, e2);
    }

    private int compareNodes(Node z1, Node z2) {
        boolean ascending;
        boolean bl = ascending = this.fSortDirection == 128;
        if ((this.fMode & 2) > 0) {
            return this.compareByNames(z1, z2, true);
        }
        switch (this.fSortBy) {
            default: {
                return 0;
            }
            case 1: {
                return this.compareByNames(z1, z2, ascending);
            }
            case 2: {
                return this.compare(ZipLabelProvider.getTypeLabel(z1), ZipLabelProvider.getTypeLabel(z2), ascending);
            }
            case 3: {
                return this.compare(z1.getTime(), z2.getTime(), ascending);
            }
            case 4: {
                return this.compare(z1.getSize(), z2.getSize(), ascending);
            }
            case 5: {
                return z1 instanceof ZipNode && z2 instanceof ZipNode ? this.compare(Math.round(((ZipNode)z1).getRatio()), Math.round(((ZipNode)z2).getRatio()), ascending) : 0;
            }
            case 6: {
                return z1 instanceof ZipNode && z2 instanceof ZipNode ? this.compare(((ZipNode)z1).getCompressedSize(), ((ZipNode)z2).getCompressedSize(), ascending) : 0;
            }
            case 7: {
                return z1 instanceof ZipNode && z2 instanceof ZipNode ? this.compare(((ZipNode)z1).getCrc(), ((ZipNode)z2).getCrc(), ascending) : 0;
            }
            case 8: {
                return 0;
            }
            case 9: 
        }
        return this.compare(z1.getPath(), z2.getPath(), ascending);
    }

    private int compareByNames(Node z1, Node z2, boolean ascending) {
        if (z1.isFolder() && !z2.isFolder()) {
            return ascending ? -1 : 1;
        }
        if (z2.isFolder() && !z1.isFolder()) {
            return ascending ? 1 : -1;
        }
        return this.compare(z1.getName(), z2.getName(), ascending);
    }

    private int compare(String s1, String s2, boolean ascending) {
        return ascending ? s1.compareToIgnoreCase(s2) : s2.compareToIgnoreCase(s1);
    }

    private int compare(long l1, long l2, boolean ascending) {
        if (l1 == l2) {
            return 0;
        }
        return l1 < l2 ? (ascending ? -1 : 1) : (ascending ? 1 : -1);
    }

    public void update() {
        IPreferenceStore store = ZipEditorPlugin.getDefault().getPreferenceStore();
        this.fSortBy = store.getInt("SORT_BY");
        this.fSortDirection = store.getInt("SORT_DIRECTION");
        this.fSortEnabled = store.getBoolean(String.valueOf(this.fPreferencePrefix) + "SORT_ENABLED");
        this.fMode = store.getInt(String.valueOf(this.fPreferencePrefix) + "VIEW_MODE");
    }
}

