/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.actions;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import zipeditor.PreferenceInitializer;
import zipeditor.ZipEditorPlugin;
import zipeditor.actions.ActionMessages;
import zipeditor.actions.FileOpener;
import zipeditor.model.FileAdapter;

public class MostRecentlyUsedMenu
extends ContributionItem {
    private FileOpener fFileOpener;
    private FileAdapter fFileAdapter;

    public MostRecentlyUsedMenu(FileOpener fileOpener, FileAdapter fileAdapter) {
        this.fFileOpener = fileOpener;
        this.fFileAdapter = fileAdapter;
    }

    public boolean isDynamic() {
        return true;
    }

    public void fill(Menu menu, int index) {
        this.createMostRecentlyUsedItems(menu, index);
    }

    private void createMostRecentlyUsedItems(Menu menu, int index) {
        IPreferenceStore store = ZipEditorPlugin.getDefault().getPreferenceStore();
        FileOpener.Editor[] recentlyUsedEditors = (FileOpener.Editor[])PreferenceInitializer.split(store.getString("recentlyUsedEditors"), ",", FileOpener.Editor.class);
        int i = 0;
        int j = 0;
        while (i < recentlyUsedEditors.length) {
            final FileOpener.Editor editor = recentlyUsedEditors[i];
            if (editor != null && editor.getLabel() != null) {
                MenuItem item = new MenuItem(menu, 8, index + j++);
                item.setText(editor.getLabel());
                if (editor.getDescriptor() != null) {
                    item.setImage(ZipEditorPlugin.getImage(editor.getDescriptor().getImageDescriptor()));
                }
                Listener listener = new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.type) {
                            case 13: {
                                new ExtractJob(editor).schedule();
                            }
                        }
                    }
                };
                item.addListener(13, listener);
            }
            ++i;
        }
    }

    private class ExtractJob
    extends Job {
        private FileOpener.Editor fEditor;

        public ExtractJob(FileOpener.Editor editor) {
            super(ActionMessages.getString("MostRecentlyUsedMenu.0"));
            this.fEditor = editor;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(ActionMessages.getString("MostRecentlyUsedMenu.1"), 1);
            try {
                final Object adapter = MostRecentlyUsedMenu.this.fFileAdapter.getAdapter(IFileStore.class);
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MostRecentlyUsedMenu.this.fFileOpener.openFromOther((IFileStore)adapter, ExtractJob.this.fEditor);
                    }
                });
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

