/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.actions;

import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import zipeditor.Utils;
import zipeditor.ZipEditorPlugin;
import zipeditor.actions.ActionMessages;
import zipeditor.actions.ViewerAction;
import zipeditor.model.Node;

public class OpenAction
extends ViewerAction {
    public OpenAction(StructuredViewer viewer) {
        super(ActionMessages.getString("OpenAction.0"), viewer);
        this.setToolTipText(ActionMessages.getString("OpenAction.1"));
        this.setImageDescriptor(ZipEditorPlugin.getImageDescriptor("icons/elcl18/open.png"));
        this.setDisabledImageDescriptor(ZipEditorPlugin.getImageDescriptor("icons/dlcl18/open.png"));
    }

    public void run() {
        Node[] nodes = this.getSelectedNodes();
        if (nodes.length == 1 && nodes[0].isFolder() && this.getViewer() instanceof TreeViewer) {
            TreeViewer viewer = (TreeViewer)this.getViewer();
            viewer.setExpandedState((Object)nodes[0], !viewer.getExpandedState((Object)nodes[0]));
        } else {
            Utils.openFilesFromNodes(nodes);
        }
    }
}

