/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import zipeditor.Utils;
import zipeditor.model.Node;

public abstract class ViewerAction
extends Action {
    private StructuredViewer fViewer;

    public ViewerAction(String text, StructuredViewer viewer) {
        super(text);
        Assert.isNotNull((Object)viewer);
        this.fViewer = viewer;
    }

    public StructuredViewer getViewer() {
        return this.fViewer;
    }

    protected Node[] getSelectedNodes() {
        return Utils.getSelectedNodes(this.getSelection());
    }

    protected Node getViewerInputAsNode() {
        return (Node)((Object)this.fViewer.getInput());
    }

    protected void refreshViewer() {
        if (this.fViewer.getControl() == null || this.fViewer.getControl().isDisposed()) {
            return;
        }
        this.fViewer.getControl().setRedraw(false);
        this.fViewer.refresh();
        this.fViewer.getControl().setRedraw(true);
    }

    protected ISelection getSelection() {
        return this.fViewer.getSelection();
    }
}

