/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.operations;

import java.io.File;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.FilenameUtil;
import zipeditor.Messages;
import zipeditor.Utils;
import zipeditor.ZipEditorPlugin;

public class OpenFileOperation {
    private final Logger logger = LoggerFactory.getLogger(OpenFileOperation.class);

    public IEditorPart execute(File file) {
        IFileStore fileStore = Utils.getFileStore(file);
        if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
            file.setReadOnly();
            final IEditorInput input = Utils.createEditorInput(fileStore);
            String editorId = null;
            String inputFileName = input.getName();
            if ("xml".equals(FilenameUtil.getExtension((String)inputFileName).toLowerCase())) {
                try {
                    editorId = IDE.getEditorDescriptor((String)"*.xml").getId();
                }
                catch (PartInitException e) {
                    this.logger.error("Cannot get editor id for xml file", (Throwable)e);
                }
            }
            if (editorId == null) {
                editorId = Utils.getEditorId(fileStore);
            }
            if (Utils.isUIThread()) {
                return this.openEditor(input, editorId);
            }
            final IEditorPart[] result = new IEditorPart[1];
            final String finalEditorId = editorId;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    result[0] = OpenFileOperation.this.openEditor(input, finalEditorId);
                }
            });
            return result[0];
        }
        return null;
    }

    private IEditorPart openEditor(IEditorInput input, String editorId) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            return page.openEditor(input, editorId);
        }
        catch (PartInitException e) {
            ZipEditorPlugin.log((Object)e);
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("ZipEditor.8"), (String)e.getMessage());
            return null;
        }
    }
}

