/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalysis.ide.eplugin.communication;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.OSChecker;
import org.tizen.dynamicanalysis.ide.eplugin.DALog;

public class FocusManager
extends Thread {
    private String[] cmds;
    private int selfPid;

    public FocusManager() {
        this.selfPid = -1;
    }

    public FocusManager(int iPid) {
        this.selfPid = iPid;
    }

    @Override
    public void run() {
        String pid = "";
        String Processid = "";
        if (this.selfPid > 0) {
            pid = String.valueOf(this.selfPid);
        } else {
            ManagementFactory.getRuntimeMXBean();
            RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
            Processid = rt.getName();
            pid = Processid.substring(0, Processid.indexOf("@"));
        }
        this.cmds = new String[]{this.getDynAnalyzerPath(), pid};
        this.executeCommand(this.cmds);
    }

    private String getDynAnalyzerPath() {
        String path = "";
        path = OSChecker.isWindows() ? String.valueOf(InstallPathConfig.getSDKPath()) + "/tools/dynamic-analyzer/tool/windowactivator.bat" : (OSChecker.isMAC() ? String.valueOf(InstallPathConfig.getSDKPath()) + "/tools/dynamic-analyzer/tool/macoswindowactivator.sh" : String.valueOf(InstallPathConfig.getSDKPath()) + "/tools/dynamic-analyzer/tool/windowactivator.sh");
        DALog.printLog("activator : " + path);
        return path;
    }

    private int executeCommand(String[] cmds) {
        Runtime runtime = null;
        Process process = null;
        int retValue = 0;
        try {
            try {
                if (cmds.length == 0) {
                    retValue = -1;
                } else {
                    runtime = Runtime.getRuntime();
                    process = runtime.exec(cmds);
                    if (process != null) {
                        process.waitFor();
                        retValue = process.exitValue();
                    }
                }
            }
            catch (IOException iOException) {
                DALog.printLog("executeCommand - IOException");
                if (process != null) {
                    process.destroy();
                }
            }
            catch (InterruptedException interruptedException) {
                DALog.printLog("executeCommand - InterruptedException");
                if (process != null) {
                    process.destroy();
                }
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return retValue;
    }
}

