/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.commands;

import java.util.Map;
import org.tizen.dynamicanalyzer.cli.CliInternals;
import org.tizen.dynamicanalyzer.cli.commands.Command;
import org.tizen.dynamicanalyzer.cli.commands.ExitCode;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.sdblib.IDevice;

public final class AppsCommand
extends Command {
    public AppsCommand() {
        super("apps", 1, "show list of applications of specified target", "<ip:port|serial>");
    }

    private void printApps(Map<String, AppInfo> apps) {
        String APP_NAME_HEADER = "<Application Name>";
        String APP_ID_HEADER = "<Application ID>";
        String PACKAGE_ID_HEADER = "<Package ID>";
        int maxPackageId = "<Package ID>".length();
        int maxAppId = "<Application ID>".length();
        for (Map.Entry<String, AppInfo> entry : apps.entrySet()) {
            AppInfo appInfo = entry.getValue();
            maxPackageId = Math.max(appInfo.getPackageID().length(), maxPackageId);
            maxAppId = Math.max(appInfo.getAppID().length(), maxAppId);
        }
        String format = String.format("  %%-%ds : %%-%ds : %%s%n", maxAppId, maxPackageId);
        System.out.println("List of installed applications:");
        System.out.format(format, "<Application ID>", "<Package ID>", "<Application Name>");
        for (Map.Entry<String, AppInfo> entry : apps.entrySet()) {
            AppInfo appInfo = entry.getValue();
            System.out.format(format, appInfo.getAppID(), appInfo.getPackageID(), appInfo.getLabel());
        }
    }

    @Override
    public ExitCode processCommand(String[] args) {
        IDevice dev;
        if (args[0] == null) {
            Logger.warning((Object)"Empty target name");
            return ExitCode.EX_ARGUMENTS_ERROR;
        }
        IDevice iDevice = dev = CliInternals.isIp(args[0]) ? CliInternals.getDeviceByIp(args[0]) : CliInternals.getDeviceBySerial(args[0]);
        if (dev == null) {
            Logger.warning((String)"Target %s is not found", (Object[])new Object[]{args[0]});
            return ExitCode.EX_OPERATION_FAILED;
        }
        Map<String, AppInfo> apps = CliInternals.getApplicationMap(dev);
        if (apps != null) {
            this.printApps(apps);
        }
        return ExitCode.EX_SUCCESS;
    }
}

