/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal;

import org.eclipse.nebula.widgets.grid.AbstractRenderer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.nebula.widgets.grid.internal.TextUtils;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class DefaultRowHeaderRenderer
extends AbstractRenderer {
    int leftMargin = 6;
    int rightMargin = 8;
    int topMargin = 3;
    int bottomMargin = 3;

    public void paint(GC gc, Object value) {
        GridItem item = (GridItem)((Object)value);
        String text = this.getHeaderText(item);
        gc.setFont(this.getDisplay().getSystemFont());
        gc.setBackground(this.getDisplay().getSystemColor(22));
        if (this.isSelected() && item.getParent().getCellSelectionEnabled()) {
            gc.setBackground(item.getParent().getCellHeaderSelectionBackground());
        }
        gc.fillRectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height + 1);
        if (!item.getParent().getCellSelectionEnabled()) {
            if (this.isSelected()) {
                gc.setForeground(this.getDisplay().getSystemColor(18));
            } else {
                gc.setForeground(this.getDisplay().getSystemColor(20));
            }
            gc.drawLine(this.getBounds().x, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y);
            gc.drawLine(this.getBounds().x, this.getBounds().y, this.getBounds().x, this.getBounds().y + this.getBounds().height - 1);
            if (!this.isSelected()) {
                gc.setForeground(this.getDisplay().getSystemColor(19));
                gc.drawLine(this.getBounds().x + 1, this.getBounds().y + 1, this.getBounds().x + this.getBounds().width - 2, this.getBounds().y + 1);
                gc.drawLine(this.getBounds().x + 1, this.getBounds().y + 1, this.getBounds().x + 1, this.getBounds().y + this.getBounds().height - 2);
            }
            if (this.isSelected()) {
                gc.setForeground(this.getDisplay().getSystemColor(18));
            } else {
                gc.setForeground(this.getDisplay().getSystemColor(17));
            }
            gc.drawLine(this.getBounds().x + this.getBounds().width - 1, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
            gc.drawLine(this.getBounds().x, this.getBounds().y + this.getBounds().height - 1, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
            if (!this.isSelected()) {
                gc.setForeground(this.getDisplay().getSystemColor(18));
                gc.drawLine(this.getBounds().x + this.getBounds().width - 2, this.getBounds().y + 1, this.getBounds().x + this.getBounds().width - 2, this.getBounds().y + this.getBounds().height - 2);
                gc.drawLine(this.getBounds().x + 1, this.getBounds().y + this.getBounds().height - 2, this.getBounds().x + this.getBounds().width - 2, this.getBounds().y + this.getBounds().height - 2);
            }
        } else {
            gc.setForeground(this.getDisplay().getSystemColor(17));
            gc.drawLine(this.getBounds().x + this.getBounds().width - 1, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
            gc.drawLine(this.getBounds().x, this.getBounds().y + this.getBounds().height - 1, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
        }
        int x = this.leftMargin;
        int width = this.getBounds().width - this.leftMargin;
        width -= this.rightMargin;
        gc.setForeground(this.getDisplay().getSystemColor(21));
        int y = this.getBounds().y + (this.getBounds().height - gc.stringExtent((String)text).y) / 2;
        if (this.isSelected() && !item.getParent().getCellSelectionEnabled()) {
            gc.drawString(TextUtils.getShortString(gc, text, width), this.getBounds().x + x + 1, y + 1, true);
        } else {
            gc.drawString(TextUtils.getShortString(gc, text, width), this.getBounds().x + x, y, true);
        }
    }

    public Point computeSize(GC gc, int wHint, int hHint, Object value) {
        GridItem item = (GridItem)((Object)value);
        String text = this.getHeaderText(item);
        int x = 0;
        x += this.leftMargin;
        int y = 0;
        y += this.topMargin;
        y += gc.getFontMetrics().getHeight();
        return new Point(x += gc.stringExtent((String)text).x + this.rightMargin, y += this.bottomMargin);
    }

    private String getHeaderText(GridItem item) {
        String text = item.getHeaderText();
        if (text == null) {
            text = String.valueOf(item.getParent().indexOf(item) + 1);
        }
        return text;
    }
}

