/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CPPASTLinkageSpecification
extends ASTNode
implements ICPPASTLinkageSpecification,
IASTAmbiguityParent {
    private String fLiteral;
    private IASTDeclaration[] fAllDeclarations;
    private IASTDeclaration[] fActiveDeclarations;
    private int fLastDeclaration = -1;

    public CPPASTLinkageSpecification() {
    }

    public CPPASTLinkageSpecification(String literal) {
        this.fLiteral = literal;
    }

    public CPPASTLinkageSpecification copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CPPASTLinkageSpecification copy(IASTNode.CopyStyle style) {
        CPPASTLinkageSpecification copy = new CPPASTLinkageSpecification(this.fLiteral);
        IASTDeclaration[] iASTDeclarationArray = this.getDeclarations();
        int n = iASTDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration declaration = iASTDeclarationArray[n2];
            copy.addDeclaration(declaration == null ? null : declaration.copy(style));
            ++n2;
        }
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public String getLiteral() {
        return this.fLiteral;
    }

    public void setLiteral(String value) {
        this.assertNotFrozen();
        this.fLiteral = value;
    }

    public final void addDeclaration(IASTDeclaration decl) {
        if (decl != null) {
            decl.setParent(this);
            decl.setPropertyInParent(OWNED_DECLARATION);
            this.fAllDeclarations = (IASTDeclaration[])ArrayUtil.append(IASTDeclaration.class, this.fAllDeclarations, ++this.fLastDeclaration, decl);
            this.fActiveDeclarations = null;
        }
    }

    public final IASTDeclaration[] getDeclarations() {
        IASTDeclaration[] active = this.fActiveDeclarations;
        if (active == null) {
            active = ASTQueries.extractActiveDeclarations(this.fAllDeclarations, this.fLastDeclaration + 1);
            this.fActiveDeclarations = active;
        }
        return active;
    }

    public final IASTDeclaration[] getDeclarations(boolean includeInactive) {
        if (includeInactive) {
            this.fAllDeclarations = (IASTDeclaration[])ArrayUtil.removeNullsAfter(IASTDeclaration.class, this.fAllDeclarations, this.fLastDeclaration);
            return this.fAllDeclarations;
        }
        return this.getDeclarations();
    }

    public boolean accept(ASTVisitor action) {
        IASTDeclaration[] decls;
        if (action.shouldVisitDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        IASTDeclaration[] iASTDeclarationArray = decls = this.getDeclarations(action.includeInactiveNodes);
        int n = decls.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration decl = iASTDeclarationArray[n2];
            if (!decl.accept(action)) {
                return false;
            }
            ++n2;
        }
        return !action.shouldVisitDeclarations || action.leave(this) != 2;
    }

    public final void replace(IASTNode child, IASTNode other) {
        assert (child.isActive() == other.isActive());
        int i = 0;
        while (i <= this.fLastDeclaration) {
            if (this.fAllDeclarations[i] == child) {
                other.setParent(child.getParent());
                other.setPropertyInParent(child.getPropertyInParent());
                this.fAllDeclarations[i] = (IASTDeclaration)other;
                this.fActiveDeclarations = null;
                return;
            }
            ++i;
        }
    }
}

