/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTFieldDesignator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.gnu.c.IGCCASTArrayRangeDesignator;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.NodeWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.Scribe;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class InitializerWriter
extends NodeWriter {
    public InitializerWriter(Scribe scribe, ASTVisitor visitor, NodeCommentMap commentMap) {
        super(scribe, visitor, commentMap);
    }

    protected void writeInitializer(IASTInitializer initializer) {
        if (initializer instanceof IASTEqualsInitializer) {
            this.writeEqualsInitializer((IASTEqualsInitializer)initializer);
        } else if (initializer instanceof IASTInitializerList) {
            this.writeInitializerList((IASTInitializerList)initializer);
        } else if (initializer instanceof ICPPASTConstructorInitializer) {
            this.writeConstructorInitializer((ICPPASTConstructorInitializer)initializer);
        } else if (initializer instanceof ICASTDesignatedInitializer) {
            this.writeDesignatedInitializer((ICASTDesignatedInitializer)initializer);
        } else if (initializer instanceof ICPPASTConstructorChainInitializer) {
            this.writeConstructorChainInitializer((ICPPASTConstructorChainInitializer)initializer);
        }
        if (this.hasTrailingComments(initializer)) {
            this.writeTrailingComments(initializer, false);
        }
    }

    private void writeEqualsInitializer(IASTEqualsInitializer initializer) {
        this.scribe.print(" = ");
        IASTInitializerClause init = initializer.getInitializerClause();
        if (init != null) {
            init.accept(this.visitor);
        }
    }

    private void writeConstructorChainInitializer(ICPPASTConstructorChainInitializer initializer) {
        initializer.getMemberInitializerId().accept(this.visitor);
        initializer.getInitializer().accept(this.visitor);
    }

    private void writeInitializerList(IASTInitializerList initList) {
        this.scribe.printLBrace();
        IASTNode[] inits = initList.getClauses();
        this.writeNodeList(inits);
        this.scribe.printRBrace();
    }

    private void writeConstructorInitializer(ICPPASTConstructorInitializer ctorInit) {
        this.scribe.print('(');
        this.writeNodeList(ctorInit.getArguments());
        this.scribe.print(')');
    }

    private void writeDesignatedInitializer(ICASTDesignatedInitializer desigInit) {
        ICASTDesignator[] designators;
        ICASTDesignator[] iCASTDesignatorArray = designators = desigInit.getDesignators();
        int n = designators.length;
        int n2 = 0;
        while (n2 < n) {
            ICASTDesignator designator = iCASTDesignatorArray[n2];
            this.writeDesignator(designator);
            ++n2;
        }
        this.scribe.print(" = ");
        desigInit.getOperand().accept(this.visitor);
    }

    private void writeDesignator(ICASTDesignator designator) {
        if (designator instanceof ICASTFieldDesignator) {
            ICASTFieldDesignator fieldDes = (ICASTFieldDesignator)designator;
            this.scribe.print('.');
            fieldDes.getName().accept(this.visitor);
        } else if (designator instanceof ICASTArrayDesignator) {
            ICASTArrayDesignator arrDes = (ICASTArrayDesignator)designator;
            this.scribe.print('[');
            arrDes.getSubscriptExpression().accept(this.visitor);
            this.scribe.print(']');
        } else if (designator instanceof IGCCASTArrayRangeDesignator) {
            throw new UnsupportedOperationException("Writing of GCC ArrayRangeDesignator is not yet implemented");
        }
    }
}

