/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import org.eclipse.cdt.core.settings.model.ICSettingObject;
import org.eclipse.cdt.core.settings.model.extension.CDataObject;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescription;
import org.eclipse.cdt.internal.core.settings.model.CDataProxy;
import org.eclipse.cdt.internal.core.settings.model.ICDataProxyContainer;
import org.eclipse.cdt.internal.core.settings.model.IProxyProvider;

public abstract class CDataProxyContainer
extends CDataProxy
implements ICDataProxyContainer {
    private IProxyProvider fChildProxyProvider;

    CDataProxyContainer(CDataObject data, ICDataProxyContainer parent, CConfigurationDescription cfg) {
        super(data, parent, cfg);
    }

    public ICSettingObject getChildById(String id) {
        IProxyProvider provider = this.getChildrenProxyProvider();
        if (provider == null) {
            throw new IllegalStateException();
        }
        return provider.getProxy(id);
    }

    public ICSettingObject[] getChildrenOfKind(int kind) {
        IProxyProvider provider = this.getChildrenProxyProvider();
        if (provider == null) {
            throw new IllegalStateException();
        }
        return provider.getProxiesOfKind(kind);
    }

    protected IProxyProvider getChildrenProxyProvider() {
        if (this.fChildProxyProvider == null) {
            this.fChildProxyProvider = this.createChildProxyProvider();
        }
        return this.fChildProxyProvider;
    }

    protected abstract IProxyProvider createChildProxyProvider();

    public ICSettingObject[] getChildSettings() {
        IProxyProvider provider = this.getChildrenProxyProvider();
        if (provider == null) {
            throw new IllegalStateException();
        }
        return provider.getProxies();
    }

    public void updateChild(CDataProxy child, boolean write) {
        this.getData(write);
        this.getChildrenProxyProvider().cacheValues();
    }

    protected void setRescan(boolean rescan) {
        if (this.isRescan() == rescan) {
            return;
        }
        super.setRescan(rescan);
        if (rescan) {
            this.setRescanChildren();
        }
    }

    void setData(CDataObject data) {
        super.setData(data);
        this.setRescanChildren();
    }

    protected void setRescanChildren() {
        IProxyProvider provider = this.getChildrenProxyProvider();
        if (provider == null) {
            throw new IllegalStateException();
        }
        provider.invalidateCache();
        CDataProxy[] proxies = provider.getCachedProxies();
        int i = 0;
        while (i < proxies.length) {
            proxies[i].setRescan(true);
            ++i;
        }
    }

    public ICSettingObject getChildSettingById(String id) {
        return this.getChildrenProxyProvider().getProxy(id);
    }
}

