/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.Serializable;
import java.math.BigInteger;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.internal.core.Messages;

public class Addr64
implements IAddress,
Serializable {
    public static final Addr64 ZERO = new Addr64("0");
    public static final Addr64 MAX = new Addr64("ffffffffffffffff", 16);
    public static final BigInteger MAX_OFFSET = new BigInteger("ffffffffffffffff", 16);
    private static final int BYTES_NUM = 8;
    private static final int DIGITS_NUM = 16;
    private static final int CHARS_NUM = 18;
    private static final int BINARY_DIGITS_NUM = 64;
    private static final int BINARY_CHARS_NUM = 66;
    private final BigInteger address;

    public Addr64(byte[] addrBytes) {
        this.address = this.checkAddress(new BigInteger(1, addrBytes), true);
    }

    public Addr64(BigInteger rawaddress) {
        this(rawaddress, true);
    }

    public Addr64(BigInteger rawaddress, boolean truncate) {
        this.address = this.checkAddress(rawaddress, truncate);
    }

    public Addr64(String addr) {
        this(addr, true);
    }

    public Addr64(String addr, boolean truncate) {
        addr = addr.toLowerCase();
        this.address = addr.startsWith("0x") ? this.checkAddress(new BigInteger(addr.substring(2), 16), truncate) : this.checkAddress(new BigInteger(addr, 10), truncate);
    }

    public Addr64(String addr, int radix) {
        this(addr, radix, true);
    }

    public Addr64(String addr, int radix, boolean truncate) {
        this(new BigInteger(addr, radix), truncate);
    }

    private BigInteger checkAddress(BigInteger addr, boolean truncate) {
        if (addr.signum() == -1) {
            throw new IllegalArgumentException("Invalid Address, must be positive value");
        }
        if (addr.bitLength() > 64) {
            if (truncate) {
                return addr.and(MAX.getValue());
            }
            throw new NumberFormatException(Messages.Addr_valueOutOfRange);
        }
        return addr;
    }

    public IAddress add(BigInteger offset) {
        return new Addr64(this.address.add(offset));
    }

    public IAddress add(long offset) {
        return new Addr64(this.address.add(BigInteger.valueOf(offset)));
    }

    public BigInteger getMaxOffset() {
        return MAX_OFFSET;
    }

    public BigInteger distanceTo(IAddress other) {
        return other.getValue().subtract(this.getValue());
    }

    public boolean isMax() {
        return this.address.equals(MAX.getValue());
    }

    public boolean isZero() {
        return this.address.equals(ZERO.getValue());
    }

    public BigInteger getValue() {
        return this.address;
    }

    public int compareTo(Object other) {
        if (!(other instanceof IAddress)) {
            throw new IllegalArgumentException();
        }
        return this.getValue().compareTo(((IAddress)other).getValue());
    }

    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (!(x instanceof IAddress)) {
            return false;
        }
        return this.getValue().equals(((IAddress)x).getValue());
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int radix) {
        return this.address.toString(radix);
    }

    public String toHexAddressString() {
        String addressString = this.address.toString(16);
        StringBuffer sb = new StringBuffer(18);
        int count = 16 - addressString.length();
        sb.append("0x");
        int i = 0;
        while (i < count) {
            sb.append('0');
            ++i;
        }
        sb.append(addressString);
        return sb.toString();
    }

    public String toBinaryAddressString() {
        String addressString = this.address.toString(2);
        StringBuffer sb = new StringBuffer(66);
        int count = 64 - addressString.length();
        sb.append("0b");
        int i = 0;
        while (i < count) {
            sb.append('0');
            ++i;
        }
        sb.append(addressString);
        return sb.toString();
    }

    public int getCharsNum() {
        return 18;
    }

    public int getSize() {
        return 8;
    }
}

