/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.command.prompter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.core.command.Prompter;
import org.tizen.common.core.command.UserField;
import org.tizen.common.core.command.prompter.AbstractPrompter;
import org.tizen.common.core.command.prompter.Option;
import org.tizen.common.ui.dialog.DynamicDialog;
import org.tizen.common.ui.dialog.PasswordInputDialog;
import org.tizen.common.util.NotificationType;
import org.tizen.common.util.NotifierDialog;
import org.tizen.common.util.SWTRunner;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;

public class SWTPrompter
extends AbstractPrompter
implements Prompter {
    protected Dialog createDialog(String question, String[] optionNames, int defaultOptionIndex) {
        return new MessageDialog(SWTUtil.getActiveShell(), "Question", null, question, 3, optionNames, defaultOptionIndex){

            protected void buttonPressed(int buttonId) {
                super.buttonPressed(buttonId);
            }
        };
    }

    @Override
    public Option interact(final String question, final Option ... options) {
        LinkedHashSet<Option> reducedOptions = new LinkedHashSet<Option>();
        Option defaultOption = null;
        final ArrayList<String> optionNames = new ArrayList<String>();
        Option[] optionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            if (reducedOptions.contains(option)) {
                throw new IllegalArgumentException("Question can't have duplicated choice(s) :" + option);
            }
            optionNames.add(option.getName());
            reducedOptions.add(option);
            if (option.isDefault()) {
                if (defaultOption != null) {
                    throw new IllegalArgumentException("Question must have only one default choice");
                }
                defaultOption = option;
            }
            ++n2;
        }
        final int defaultIndex = defaultOption != null ? optionNames.indexOf(defaultOption.getName()) : 0;
        return SWTUtil.exec(new SWTRunner<Option>(){

            @Override
            public Option process() {
                Dialog dialog = SWTPrompter.this.createDialog(question, optionNames.toArray(new String[0]), defaultIndex);
                dialog.open();
                return options[dialog.getReturnCode()];
            }
        });
    }

    @Override
    public void notify(final String message) {
        SWTUtil.asyncExec(new Runnable(){

            @Override
            public void run() {
                NotifierDialog.notify("Notify", message, NotificationType.INFO);
            }
        });
    }

    @Override
    public void cancel() {
    }

    @Override
    public Object password(final String message) {
        return SWTUtil.exec(new SWTRunner<char[]>(){

            @Override
            public char[] process() {
                PasswordInputDialog dialog = new PasswordInputDialog("Password Input Dialog", message);
                dialog.open();
                if (dialog.getReturnCode() != 0) {
                    return null;
                }
                return StringUtil.trim(dialog.getValue()).toCharArray();
            }
        });
    }

    @Override
    public void error(final String message) {
        SWTUtil.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)SWTUtil.getActiveShell(), (String)"Error", (String)message);
            }
        });
    }

    @Override
    public void batch(final Collection<UserField> userFields, final Map<String, Object> options) {
        final AtomicInteger returnCode = new AtomicInteger();
        SWTUtil.syncExec(new Runnable(){

            @Override
            public void run() {
                Object object;
                DynamicDialog dynamicDialog = new DynamicDialog(userFields);
                if (options != null && options.containsKey("title") && (object = options.get("title")) instanceof String) {
                    dynamicDialog.setTitle((String)object);
                }
                returnCode.set(dynamicDialog.open());
                if (options != null) {
                    options.put("returnCode", new Integer(returnCode.get()));
                }
            }
        });
        if (returnCode.get() == 1) {
            throw new OperationCanceledException("Cancel interaction.");
        }
    }
}

