/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.CollectionUtil;
import org.tizen.common.util.MapUtil;
import org.tizen.common.util.ObjectUtil;
import org.tizen.common.util.StringUtil;

public class Assert {
    protected Assert() {
    }

    public static void fail(Object msg) {
        if (msg instanceof String) {
            throw new IllegalArgumentException((String)msg);
        }
        if (msg != null) {
            throw new IllegalArgumentException(msg.toString());
        }
    }

    public static void isTrue(boolean exp, String msg) {
        if (exp) {
            return;
        }
        Assert.fail(msg);
    }

    public static void isFalse(boolean exp, String msg) {
        if (!exp) {
            return;
        }
        Assert.fail(msg);
    }

    public static void isTrue(boolean exp) {
        Assert.isTrue(exp, "Expression must be true");
    }

    public static void isFalse(boolean exp) {
        Assert.isFalse(exp, "Expression must be false");
    }

    public static void isNull(Object obj, String msg) {
        Assert.isTrue(obj == null, msg);
    }

    public static void notNull(Object obj, String msg) {
        Assert.isFalse(obj == null, msg);
    }

    public static void isNull(Object obj) {
        Assert.isNull(obj, "Object must be null");
    }

    public static void notNull(Object obj) {
        Assert.notNull(obj, "Object must NOT be null");
    }

    public static void isEqual(Object obj1, Object obj2, String message) {
        if (ObjectUtil.equals(obj1, obj2)) {
            return;
        }
        Assert.fail(message);
    }

    public static void isEqual(Object obj1, Object obj2) {
        Assert.isEqual(obj1, obj2, "Objects are not equal");
    }

    public static void hasLength(String text, String msg) {
        if (StringUtil.hasLength(text)) {
            return;
        }
        Assert.fail(msg);
    }

    public static void hasLength(String text) {
        Assert.hasLength(text, "String argument must have length; it must not be null or empty");
    }

    public static void hasText(String text, String message) {
        if (StringUtil.hasText(text)) {
            return;
        }
        Assert.fail(message);
    }

    public static void hasText(String text) {
        Assert.hasText(text, "String argument must have text; it must not be null, empty, or blank");
    }

    public static void doesNotContain(String textToSearch, String substring, String msg) {
        if (!StringUtil.hasLength(textToSearch)) {
            return;
        }
        if (!StringUtil.hasLength(substring)) {
            return;
        }
        if (!textToSearch.contains(substring)) {
            return;
        }
        Assert.fail(msg);
    }

    public static void doesNotContain(String textToSearch, String substring) {
        Assert.doesNotContain(textToSearch, substring, "String argument must not contain the substring [" + substring + "]");
    }

    public static void contains(String textToSearch, String substring, String msg) {
        if (!StringUtil.hasLength(textToSearch)) {
            return;
        }
        if (!StringUtil.hasLength(substring)) {
            return;
        }
        if (textToSearch.contains(substring)) {
            return;
        }
        Assert.fail(msg);
    }

    public static void contains(String textToSearch, String substring) {
        Assert.contains(textToSearch, substring, "String argument must contain the substring [" + substring + "]");
    }

    public static <T> void notEmpty(T[] array, String message) {
        if (ArrayUtil.isEmpty(array)) {
            Assert.fail(message);
        }
    }

    public static void notEmpty(Object[] array) {
        Assert.notEmpty(array, "Array must not be empty: it must contain at least 1 element");
    }

    public static void noNullElements(Object[] array, String msg) {
        int i = 0;
        int n = ArrayUtil.size(array);
        while (i < n) {
            if (array[i] == null) {
                Assert.fail(msg);
            }
            ++i;
        }
    }

    public static void noNullElements(Object[] array) {
        Assert.noNullElements(array, "Array must not contain any null elements");
    }

    public static void notEmpty(Collection<?> collection, String msg) {
        if (!CollectionUtil.isEmpty(collection)) {
            return;
        }
        Assert.fail(msg);
    }

    public static void notEmpty(Collection<?> collection) {
        Assert.notEmpty(collection, "Collection must not be empty: it must contain at least 1 element");
    }

    public static void notEmpty(Map<?, ?> map, String msg) {
        if (!MapUtil.isEmpty(map)) {
            return;
        }
        Assert.fail(msg);
    }

    public static void notEmpty(Map<?, ?> map) {
        Assert.notEmpty(map, "Map must not be empty; it must contain at least one entry");
    }

    public static void isInstanceOf(Class<?> type, Object obj, String msg) {
        Assert.notNull(type, "Type to check against must not be null");
        if (type.isInstance(obj)) {
            return;
        }
        Assert.fail(MessageFormat.format("{0}, Object of class [{1}] must be aan instance of {2}", msg, obj == null ? "null" : obj.getClass().getName(), type));
    }

    public static void isInstanceOf(Class<?> type, Object obj) {
        Assert.isInstanceOf(type, obj, "");
    }

    public static void isAssignable(Class<?> superType, Class<?> subType, String msg) {
        Assert.notNull(superType, "Type to check against must not be null");
        Assert.notNull(subType, "Type to assign must not be null");
        if (superType.isAssignableFrom(subType)) {
            return;
        }
        Assert.fail(MessageFormat.format("{0}, {1} is not assignable to {2}", msg, subType, superType));
    }

    public static void isAssignable(Class<?> superType, Class<?> subType) {
        Assert.isAssignable(superType, subType, "");
    }
}

