/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.CommonPlugin;
import org.tizen.common.core.application.InstallProfileConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.launch.LaunchMessages;
import org.tizen.common.rds.ui.preference.RdsPreferencePage;
import org.tizen.common.ui.dialog.NotificationIconType;
import org.tizen.common.ui.dialog.NotificationTrayPopup;
import org.tizen.common.ui.dialog.ShowQuestionToggleDialog;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.Assert;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.sdblib.Device;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.PlatformCapability;
import org.tizen.sdblib.SmartDevelopmentBridge;

public class LaunchUtil {
    private static final String PREF_KEY_PLATFORM_IS_DIFFERENT_ALWAYS = "pref.launch.always.platform.is.different";
    private static final String PREF_KEY_PLATFORM_IS_UNKNOWN_ALWAYS = "pref.launch.always.platform.is.unknown";
    private static final String CAN_LAUNCH_DELIMITER = "_-_";
    private static final Logger logger = LoggerFactory.getLogger(LaunchUtil.class);

    public static IDevice getDevice(ILaunchConfiguration configuration, String serialNoKey) throws CoreException {
        String deviceSerialNo = configuration.getAttribute(serialNoKey, "");
        IDevice[] devices = SmartDevelopmentBridge.getBridge().getDevices();
        if (ArrayUtil.isEmpty(devices)) {
            return null;
        }
        IDevice[] iDeviceArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice device = iDeviceArray[n2];
            if (device.getSerialNumber().equals(deviceSerialNo)) {
                return device;
            }
            ++n2;
        }
        return null;
    }

    public static IDevice getDevice(ILaunch launch, String serialNoKey) throws CoreException {
        String deviceSerialNo = launch.getAttribute(serialNoKey);
        IDevice[] devices = SmartDevelopmentBridge.getBridge().getDevices();
        if (ArrayUtil.isEmpty(devices)) {
            return null;
        }
        IDevice[] iDeviceArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice device = iDeviceArray[n2];
            if (device.getSerialNumber().equals(deviceSerialNo)) {
                return device;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isRdsMode(IProject project) {
        return RdsPreferencePage.isRdsMode(project);
    }

    public static IProject getProject(ILaunchConfiguration config) throws CoreException {
        IProject project = null;
        String projectName = config.getAttribute("org.tizen.common.CONFIG_ATTR_PROJECT_NAME", "");
        if (StringUtil.isEmpty(projectName)) {
            IStructuredSelection sel;
            Object res;
            ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
            if (selection instanceof IStructuredSelection && (res = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
                project = ((IResource)res).getProject();
            }
        } else {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return project;
    }

    public static boolean checkProfile(IDevice device, IProject project) throws CoreException {
        String deviceParentProfile;
        Assert.notNull(project);
        String appProfile = LaunchMessages.UNKNOWN_PROFILE;
        TizenProjectDescription description = ProjectUtil.getTizenProjectDescription(project);
        if (description != null) {
            appProfile = description.getProfileName();
        }
        String deviceType = device.isEmulator() ? "emulator" : "device";
        ProfileInfo profileInfo = ProfileInfo.getProfileInfo(device);
        if (profileInfo == null) {
            String message = NLS.bind((String)LaunchMessages.DIALOG_QUESTION_CONTINUE_EVEN_IF_IT_IS_UNKNOWN_PLATFORM, (Object)deviceType);
            return LaunchUtil.continueToLaunch(LaunchMessages.DIALOG_TITLE_UNKNOWN_PLATFORM, message, LaunchMessages.DIALOG_TOGGLE_ALWAYS_LAUNCH_WITHOUT_ASKING, PREF_KEY_PLATFORM_IS_UNKNOWN_ALWAYS);
        }
        String deviceProfile = profileInfo.getProfile();
        if (deviceProfile == null) {
            deviceProfile = LaunchMessages.UNKNOWN_PROFILE;
        }
        if ((deviceParentProfile = profileInfo.getParentProfile()) == null) {
            deviceParentProfile = LaunchMessages.UNKNOWN_PROFILE;
        }
        if (!(appProfile.equalsIgnoreCase("tizen") || deviceParentProfile.equalsIgnoreCase(appProfile) || deviceProfile.equalsIgnoreCase(appProfile) || LaunchUtil.canLaunch(device, appProfile))) {
            Object[] bindWord = new String[]{appProfile, deviceProfile, deviceType};
            String message = NLS.bind((String)LaunchMessages.DIALOG_QUESTION_CONTINUE_EVEN_IF_IT_IS_DIFFERENT_PROFILE, (Object[])bindWord);
            boolean checked = LaunchUtil.checkAlwaysAsking();
            if (!LaunchUtil.continueToLaunch(LaunchMessages.DIALOG_TITLE_DIFFERENT_PROFILE, message, LaunchMessages.DIALOG_TOGGLE_ALWAYS_LAUNCH_WITHOUT_ASKING, PREF_KEY_PLATFORM_IS_DIFFERENT_ALWAYS)) {
                return false;
            }
            final String notiMessage = NLS.bind((String)LaunchMessages.INCOMPATIBLE_PROFILE, (Object)appProfile, (Object)deviceParentProfile);
            boolean checkedAgain = LaunchUtil.checkAlwaysAsking();
            ProfileInfo info = InstallProfileConfig.getProfileInfoToProfile(deviceProfile);
            if (checked && checkedAgain && info != null && !info.isCustomProfile()) {
                SWTUtil.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NotificationTrayPopup.notify(LaunchMessages.INCOMPATIBLE_TITLE_PROFILE, notiMessage, NotificationIconType.INFO);
                    }
                });
            }
        }
        return true;
    }

    private static boolean checkAlwaysAsking() {
        IPreferenceStore ps = CommonPlugin.getDefault().getPreferenceStore();
        return ps.getBoolean(PREF_KEY_PLATFORM_IS_DIFFERENT_ALWAYS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean canLaunch(IDevice device, String appProfile) {
        try {
            String[] canLaunchValues;
            PlatformCapability pc = new PlatformCapability((Device)device);
            String canLaunchValue = pc.getCanLaunch();
            if (canLaunchValue == null) {
                logger.debug("Can launch value is null");
                return false;
            }
            String[] stringArray = canLaunchValues = canLaunchValue.trim().split(CAN_LAUNCH_DELIMITER);
            int n = canLaunchValues.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String canLaunch = stringArray[n2];
                if (canLaunch.equals(appProfile) && !canLaunch.equals("unknown")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (IOException e) {
            logger.debug("Could not get platform capability", (Throwable)e);
            return false;
        }
    }

    public static boolean continueToLaunch(String title, String message, String toogleMessage, String togglePreferenceKey) {
        ShowQuestionToggleDialog dialogRunnable = new ShowQuestionToggleDialog(title, message, toogleMessage, togglePreferenceKey);
        Display.getDefault().syncExec((Runnable)dialogRunnable);
        return dialogRunnable.wantToContinue();
    }
}

