/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.error;

import org.tizen.dynamicanalyzer.nl.ErrorLabels;

public enum DAErrorCode {
    EPERM(1L, ErrorLabels.EPERM),
    ENOENT(2L, ErrorLabels.ENOENT),
    ESRCH(3L, ErrorLabels.ESRCH),
    EINTR(4L, ErrorLabels.EINTR),
    EIO(5L, ErrorLabels.EIO),
    ENXIO(6L, ErrorLabels.ENXIO),
    E2BIG(7L, ErrorLabels.E2BIG),
    ENOEXEC(8L, ErrorLabels.ENOEXEC),
    EBADF(9L, ErrorLabels.EBADF),
    ECHILD(10L, ErrorLabels.ECHILD),
    EAGAIN(11L, ErrorLabels.EAGAIN),
    ENOMEM(12L, ErrorLabels.ENOMEM),
    EACCES(13L, ErrorLabels.EACCES),
    EFAULT(14L, ErrorLabels.EFAULT),
    ENOTBLK(15L, ErrorLabels.ENOTBLK),
    EBUSY(16L, ErrorLabels.EBUSY),
    EEXIST(17L, ErrorLabels.EEXIST),
    EXDEV(18L, ErrorLabels.EXDEV),
    ENODEV(19L, ErrorLabels.ENODEV),
    ENOTDIR(20L, ErrorLabels.ENOTDIR),
    EISDIR(21L, ErrorLabels.EISDIR),
    EINVAL(22L, ErrorLabels.EINVAL),
    ENFILE(23L, ErrorLabels.ENFILE),
    EMFILE(24L, ErrorLabels.EMFILE),
    ENOTTY(25L, ErrorLabels.ENOTTY),
    ETXTBSY(26L, ErrorLabels.ETXTBSY),
    EFBIG(27L, ErrorLabels.EFBIG),
    ENOSPC(28L, ErrorLabels.ENOSPC),
    ESPIPE(29L, ErrorLabels.ESPIPE),
    EROFS(30L, ErrorLabels.EROFS),
    EMLINK(31L, ErrorLabels.EMLINK),
    EPIPE(32L, ErrorLabels.EPIPE),
    EDOM(33L, ErrorLabels.EDOM),
    ERANGE(34L, ErrorLabels.ERANGE),
    EDEADLK(35L, ErrorLabels.EDEADLK),
    ENAMETOOLONG(36L, ErrorLabels.ENAMETOOLONG),
    ENOLCK(37L, ErrorLabels.ENOLCK),
    ENOSYS(38L, ErrorLabels.ENOSYS),
    ENOTEMPTY(39L, ErrorLabels.ENOTEMPTY),
    ELOOP(40L, ErrorLabels.ELOOP),
    ENOMSG(42L, ErrorLabels.ENOMSG),
    EIDRM(43L, ErrorLabels.EIDRM),
    ECHRNG(44L, ErrorLabels.ECHRNG),
    EL2NSYNC(45L, ErrorLabels.EL2NSYNC),
    EL3HLT(46L, ErrorLabels.EL3HLT),
    EL3RST(47L, ErrorLabels.EL3RST),
    ELNRNG(48L, ErrorLabels.ELNRNG),
    EUNATCH(49L, ErrorLabels.EUNATCH),
    ENOCSI(50L, ErrorLabels.ENOCSI),
    EL2HLT(51L, ErrorLabels.EL2HLT),
    EBADE(52L, ErrorLabels.EBADE),
    EBADR(53L, ErrorLabels.EBADR),
    EXFULL(54L, ErrorLabels.EXFULL),
    ENOANO(55L, ErrorLabels.ENOANO),
    EBADRQC(56L, ErrorLabels.EBADRQC),
    EBADSLT(57L, ErrorLabels.EBADSLT),
    EBFONT(59L, ErrorLabels.EBFONT),
    ENOSTR(60L, ErrorLabels.ENOSTR),
    ENODATA(61L, ErrorLabels.ENODATA),
    ETIME(62L, ErrorLabels.ETIME),
    ENOSR(63L, ErrorLabels.ENOSR),
    ENONET(64L, ErrorLabels.ENONET),
    ENOPKG(65L, ErrorLabels.ENOPKG),
    EREMOTE(66L, ErrorLabels.EREMOTE),
    ENOLINK(67L, ErrorLabels.ENOLINK),
    EADV(68L, ErrorLabels.EADV),
    ESRMNT(69L, ErrorLabels.ESRMNT),
    ECOMM(70L, ErrorLabels.ECOMM),
    EPROTO(71L, ErrorLabels.EPROTO),
    EMULTIHOP(72L, ErrorLabels.EMULTIHOP),
    EDOTDOT(73L, ErrorLabels.EDOTDOT),
    EBADMSG(74L, ErrorLabels.EBADMSG),
    EOVERFLOW(75L, ErrorLabels.EOVERFLOW),
    ENOTUNIQ(76L, ErrorLabels.ENOTUNIQ),
    EBADFD(77L, ErrorLabels.EBADFD),
    EREMCHG(78L, ErrorLabels.EREMCHG),
    ELIBACC(79L, ErrorLabels.ELIBACC),
    ELIBBAD(80L, ErrorLabels.ELIBBAD),
    ELIBSCN(81L, ErrorLabels.ELIBSCN),
    ELIBMAX(82L, ErrorLabels.ELIBMAX),
    ELIBEXEC(83L, ErrorLabels.ELIBEXEC),
    EILSEQ(84L, ErrorLabels.EILSEQ),
    ERESTART(85L, ErrorLabels.ERESTART),
    ESTRPIPE(86L, ErrorLabels.ESTRPIPE),
    EUSERS(87L, ErrorLabels.EUSERS),
    ENOTSOCK(88L, ErrorLabels.ENOTSOCK),
    EDESTADDRREQ(89L, ErrorLabels.EDESTADDRREQ),
    EMSGSIZE(90L, ErrorLabels.EMSGSIZE),
    EPROTOTYPE(91L, ErrorLabels.EPROTOTYPE),
    ENOPROTOOPT(92L, ErrorLabels.ENOPROTOOPT),
    EPROTONOSUPPORT(93L, ErrorLabels.EPROTONOSUPPORT),
    ESOCKTNOSUPPORT(94L, ErrorLabels.ESOCKTNOSUPPORT),
    EOPNOTSUPP(95L, ErrorLabels.EOPNOTSUPP),
    EPFNOSUPPORT(96L, ErrorLabels.EPFNOSUPPORT),
    EAFNOSUPPORT(97L, ErrorLabels.EAFNOSUPPORT),
    EADDRINUSE(98L, ErrorLabels.EADDRINUSE),
    EADDRNOTAVAIL(99L, ErrorLabels.EADDRNOTAVAIL),
    ENETDOWN(100L, ErrorLabels.ENETDOWN),
    ENETUNREACH(101L, ErrorLabels.ENETUNREACH),
    ENETRESET(102L, ErrorLabels.ENETRESET),
    ECONNABORTED(103L, ErrorLabels.ECONNABORTED),
    ECONNRESET(104L, ErrorLabels.ECONNRESET),
    ENOBUFS(105L, ErrorLabels.ENOBUFS),
    EISCONN(106L, ErrorLabels.EISCONN),
    ENOTCONN(107L, ErrorLabels.ENOTCONN),
    ESHUTDOWN(108L, ErrorLabels.ESHUTDOWN),
    ETOOMANYREFS(109L, ErrorLabels.ETOOMANYREFS),
    ETIMEDOUT(110L, ErrorLabels.ETIMEDOUT),
    ECONNREFUSED(111L, ErrorLabels.ECONNREFUSED),
    EHOSTDOWN(112L, ErrorLabels.EHOSTDOWN),
    EHOSTUNREACH(113L, ErrorLabels.EHOSTUNREACH),
    EALREADY(114L, ErrorLabels.EALREADY),
    EINPROGRESS(115L, ErrorLabels.EINPROGRESS),
    ESTALE(116L, ErrorLabels.ESTALE),
    EUCLEAN(117L, ErrorLabels.EUCLEAN),
    ENOTNAM(118L, ErrorLabels.ENOTNAM),
    ENAVAIL(119L, ErrorLabels.ENAVAIL),
    EISNAM(120L, ErrorLabels.EISNAM),
    EREMOTEIO(121L, ErrorLabels.EREMOTEIO),
    EDQUOT(122L, ErrorLabels.EDQUOT),
    ENOMEDIUM(123L, ErrorLabels.ENOMEDIUM),
    EMEDIUMTYPE(124L, ErrorLabels.EMEDIUMTYPE),
    ECANCELED(125L, ErrorLabels.ECANCELED),
    ENOKEY(126L, ErrorLabels.ENOKEY),
    EKEYEXPIRED(127L, ErrorLabels.EKEYEXPIRED),
    EKEYREVOKED(128L, ErrorLabels.EKEYREVOKED),
    EKEYREJECTED(129L, ErrorLabels.EKEYREJECTED),
    EOWNERDEAD(130L, ErrorLabels.EOWNERDEAD),
    ENOTRECOVERABLE(131L, ErrorLabels.ENOTRECOVERABLE),
    E_SUCCESS(DAErrorCode.SET_E_SEVERITY(0L), ErrorLabels.E_SUCCESS),
    E_FAILURE(DAErrorCode.SET_E_SEVERITY(1L), ErrorLabels.E_FAILURE),
    ERR_SRC_FRAMEWORK(DAErrorCode.getE_FAILURE() + DAErrorCode.SET_E_TYPE(1L), ErrorLabels.ERR_SRC_FRAMEWORK),
    ERR_SRC_USER(DAErrorCode.getE_FAILURE() + DAErrorCode.SET_E_TYPE(2L), ErrorLabels.ERR_SRC_USER),
    E_ADDRESS_CHANGED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1100L), ErrorLabels.E_ADDRESS_CHANGED),
    E_ALREADY_BOUND(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1101L), ErrorLabels.E_ALREADY_BOUND),
    E_ALREADY_CONNECTED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1102L), ErrorLabels.E_ALREADY_CONNECTED),
    E_ALREADY_OPENED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1103L), ErrorLabels.E_ALREADY_OPENED),
    E_AUTHENTICATION(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1104L), ErrorLabels.E_AUTHENTICATION),
    E_APP_NOT_INSTALLED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1105L), ErrorLabels.E_APP_NOT_INSTALLED),
    E_ALREADY_SET(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1106L), ErrorLabels.E_ALREADY_SET),
    E_CHUNKED_TRANSACTION(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1300L), ErrorLabels.E_CHUNKED_TRANSACTION),
    E_CONNECTION_BUSY(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1301L), ErrorLabels.E_CONNECTION_BUSY),
    E_CONNECTION_FAILED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1302L), ErrorLabels.E_CONNECTION_FAILED),
    E_CONNECTION_RESET(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1303L), ErrorLabels.E_CONNECTION_RESET),
    E_CREDENTIAL_EXPIRED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1304L), ErrorLabels.E_CREDENTIAL_EXPIRED),
    E_CERTIFICATE_VERIFICATION_FAILED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1305L), ErrorLabels.E_CERTIFICATE_VERIFICATION_FAILED),
    E_DATA_NOT_FOUND(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1400L), ErrorLabels.E_DATA_NOT_FOUND),
    E_DATABASE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1401L), ErrorLabels.E_DATABASE),
    E_DECODING_FAILED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1402L), ErrorLabels.E_DECODING_FAILED),
    E_DEVICE_BUSY(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1403L), ErrorLabels.E_DEVICE_BUSY),
    E_DEVICE_FAILED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1404L), ErrorLabels.E_DEVICE_FAILED),
    E_DEVICE_INCOMPATIBLE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1405L), ErrorLabels.E_DEVICE_INCOMPATIBLE),
    E_DEVICE_UNAVAILABLE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1406L), ErrorLabels.E_DEVICE_UNAVAILABLE),
    E_DHCP(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1407L), ErrorLabels.E_DHCP),
    E_DIMENSION_CHANGED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1408L), ErrorLabels.E_DIMENSION_CHANGED),
    E_DNS(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1409L), ErrorLabels.E_DNS),
    E_DNS_NOT_FOUND(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1410L), ErrorLabels.E_DNS_NOT_FOUND),
    E_EFFECTS_DISABLED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1500L), ErrorLabels.E_EFFECTS_DISABLED),
    E_EMPTY_BODY(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1501L), ErrorLabels.E_EMPTY_BODY),
    E_ENCODING_FAILED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1502L), ErrorLabels.E_ENCODING_FAILED),
    E_END_OF_FILE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1503L), ErrorLabels.E_END_OF_FILE),
    E_FDN_MODE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1600L), ErrorLabels.E_FDN_MODE),
    E_FILE_ALREADY_EXIST(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1601L), ErrorLabels.E_FILE_ALREADY_EXIST),
    E_FILE_NOT_FOUND(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1602L), ErrorLabels.E_FILE_NOT_FOUND),
    E_GROUP_NOT_FOUND(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1700L), ErrorLabels.E_GROUP_NOT_FOUND),
    E_HOST_NOT_FOUND(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1800L), ErrorLabels.E_HOST_NOT_FOUND),
    E_HOST_UNREACHABLE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1801L), ErrorLabels.E_HOST_UNREACHABLE),
    E_HTTP_USER(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1802L), ErrorLabels.E_HTTP_USER),
    E_ILLEGAL_ACCESS(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1900L), ErrorLabels.E_ILLEGAL_ACCESS),
    E_IN_PROGRESS(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1901L), ErrorLabels.E_IN_PROGRESS),
    E_INACCESSIBLE_PATH(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1902L), ErrorLabels.E_INACCESSIBLE_PATH),
    E_INIT_FAILED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1903L), ErrorLabels.E_INIT_FAILED),
    E_INSTANTIATION_FAILED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1904L), ErrorLabels.E_INSTANTIATION_FAILED),
    E_INSUFFICIENT_PRIORITY(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1905L), ErrorLabels.E_INSUFFICIENT_PRIORITY),
    E_INTERRUPTED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1906L), ErrorLabels.E_INTERRUPTED),
    E_INVALID_ACCOUNT(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1907L), ErrorLabels.E_INVALID_ACCOUNT),
    E_INVALID_ADDRESS(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1908L), ErrorLabels.E_INVALID_ADDRESS),
    E_INVALID_ARG(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1909L), ErrorLabels.E_INVALID_ARG),
    E_INVALID_CONDITION(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1910L), ErrorLabels.E_INVALID_CONDITION),
    E_INVALID_CONNECTION(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1911L), ErrorLabels.E_INVALID_CONNECTION),
    E_INVALID_CONTENT(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1912L), ErrorLabels.E_INVALID_CONTENT),
    E_INVALID_CONTEXT(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1913L), ErrorLabels.E_INVALID_CONTEXT),
    E_INVALID_DATA(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1914L), ErrorLabels.E_INVALID_DATA),
    E_INVALID_DOMAIN(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1915L), ErrorLabels.E_INVALID_DOMAIN),
    E_INVALID_ENCODING_RANGE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1916L), ErrorLabels.E_INVALID_ENCODING_RANGE),
    E_INVALID_FORMAT(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1917L), ErrorLabels.E_INVALID_FORMAT),
    E_INVALID_HEADER(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1918L), ErrorLabels.E_INVALID_HEADER),
    E_INVALID_KEY(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1919L), ErrorLabels.E_INVALID_KEY),
    E_INVALID_OPERATION(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1920L), ErrorLabels.E_INVALID_OPERATION),
    E_INVALID_PROXY(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1921L), ErrorLabels.E_INVALID_PROXY),
    E_INVALID_SIM_STATE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1922L), ErrorLabels.E_INVALID_SIM_STATE),
    E_INVALID_SERVER(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1923L), ErrorLabels.E_INVALID_SERVER),
    E_INVALID_SESSION(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1924L), ErrorLabels.E_INVALID_SESSION),
    E_INVALID_SOCKET(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1925L), ErrorLabels.E_INVALID_SOCKET),
    E_INVALID_STATE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1926L), ErrorLabels.E_INVALID_STATE),
    E_INVALID_TRANSACTION(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1927L), ErrorLabels.E_INVALID_TRANSACTION),
    E_IO(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1928L), ErrorLabels.E_IO),
    E_NOT_JOINED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1929L), ErrorLabels.E_NOT_JOINED),
    E_INVALID_CERTIFICATE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1930L), ErrorLabels.E_INVALID_CERTIFICATE),
    E_INVALID_URL(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(1931L), ErrorLabels.E_INVALID_URL),
    E_KEY_ALREADY_EXIST(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2100L), ErrorLabels.E_KEY_ALREADY_EXIST),
    E_KEY_NOT_FOUND(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2101L), ErrorLabels.E_KEY_NOT_FOUND),
    E_LANDMARK(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2200L), ErrorLabels.E_LANDMARK),
    E_LIBRARY_NOT_FOUND(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2201L), ErrorLabels.E_LIBRARY_NOT_FOUND),
    E_LIBRARY_NOT_LOADED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2202L), ErrorLabels.E_LIBRARY_NOT_LOADED),
    E_LINK(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2203L), ErrorLabels.E_LINK),
    E_LOCATION(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2204L), ErrorLabels.E_LOCATION),
    E_LOCATION_SERVICE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2205L), ErrorLabels.E_LOCATION_SERVICE),
    E_LOCK_FAILED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2206L), ErrorLabels.E_LOCK_FAILED),
    E_LANGUAGE_NOT_SET(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2207L), ErrorLabels.E_LANGUAGE_NOT_SET),
    E_MAX_EXCEEDED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2300L), ErrorLabels.E_MAX_EXCEEDED),
    E_MISSING_INPUT(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2301L), ErrorLabels.E_MISSING_INPUT),
    E_MOBILE_FAILED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2302L), ErrorLabels.E_MOBILE_FAILED),
    E_MODEL_NOT_FOUND(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2303L), ErrorLabels.E_MODEL_NOT_FOUND),
    E_NETWORK_FAILED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2400L), ErrorLabels.E_NETWORK_FAILED),
    E_NETWORK_UNAVAILABLE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2401L), ErrorLabels.E_NETWORK_UNAVAILABLE),
    E_NO_CERTIFICATE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2402L), ErrorLabels.E_NO_CERTIFICATE),
    E_NOT_A_MEMBER(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2403L), ErrorLabels.E_NOT_A_MEMBER),
    E_NOT_PAIRED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2404L), ErrorLabels.E_NOT_PAIRED),
    E_NOT_RESPONDING(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2405L), ErrorLabels.E_NOT_RESPONDING),
    E_NUM_FORMAT(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2406L), ErrorLabels.E_NUM_FORMAT),
    E_OBJ_ALREADY_EXIST(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2500L), ErrorLabels.E_OBJ_ALREADY_EXIST),
    E_OBJ_NOT_FOUND(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2501L), ErrorLabels.E_OBJ_NOT_FOUND),
    E_OBJECT_LOCKED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2502L), ErrorLabels.E_OBJECT_LOCKED),
    E_ON_INITIALIZING(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2503L), ErrorLabels.E_ON_INITIALIZING),
    E_OPERATION_CANCELED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2504L), ErrorLabels.E_OPERATION_CANCELED),
    E_OPERATION_FAILED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2505L), ErrorLabels.E_OPERATION_FAILED),
    E_OUT_OF_MEMORY(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2506L), ErrorLabels.E_OUT_OF_MEMORY),
    E_OUT_OF_RANGE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2507L), ErrorLabels.E_OUT_OF_RANGE),
    E_OVERFLOW(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2508L), ErrorLabels.E_OVERFLOW),
    E_PAIRING_FAILED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2600L), ErrorLabels.E_PAIRING_FAILED),
    E_PARSING_FAILED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2601L), ErrorLabels.E_PARSING_FAILED),
    E_PRIVILEGE_DENIED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2602L), ErrorLabels.E_PRIVILEGE_DENIED),
    E_READ_ONLY(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2800L), ErrorLabels.E_READ_ONLY),
    E_REJECTED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2801L), ErrorLabels.E_REJECTED),
    E_REMOTE_DEVICE_NOT_FOUND(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2802L), ErrorLabels.E_REMOTE_DEVICE_NOT_FOUND),
    E_REMOVE_SERVICE_NOT_FOUND(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2803L), ErrorLabels.E_REMOVE_SERVICE_NOT_FOUND),
    E_RESOURCE_UNAVAILABLE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2804L), ErrorLabels.E_RESOURCE_UNAVAILABLE),
    E_RIGHT_EXPIRED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2805L), ErrorLabels.E_RIGHT_EXPIRED),
    E_SECTION_ALREADY_EXIST(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2900L), ErrorLabels.E_SECTION_ALREADY_EXIST),
    E_SECTION_NOT_FOUND(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2901L), ErrorLabels.E_SECTION_NOT_FOUND),
    E_SERVER(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2902L), ErrorLabels.E_SERVER),
    E_SERVICE_BUSY(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2903L), ErrorLabels.E_SERVICE_BUSY),
    E_SERVICE_LIMITED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2904L), ErrorLabels.E_SERVICE_LIMITED),
    E_SERVICE_LOCKED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2905L), ErrorLabels.E_SERVICE_LOCKED),
    E_SERVICE_UNAVAILABLE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2906L), ErrorLabels.E_SERVICE_UNAVAILABLE),
    E_SESSION_DEACTIVATED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2907L), ErrorLabels.E_SESSION_DEACTIVATED),
    E_SESSION_UNAVAILABLE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2908L), ErrorLabels.E_SESSION_UNAVAILABLE),
    E_SIZE_MISMATCH(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2909L), ErrorLabels.E_SIZE_MISMATCH),
    E_SOCKET_USER(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2910L), ErrorLabels.E_SOCKET_USER),
    E_STORAGE_FULL(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2911L), ErrorLabels.E_STORAGE_FULL),
    E_SYMBOL_NOT_FOUND(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2912L), ErrorLabels.E_SYMBOL_NOT_FOUND),
    E_SYNTAX(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2913L), ErrorLabels.E_SYNTAX),
    E_SYSTEM(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2914L), ErrorLabels.E_SYSTEM),
    E_SERVICE_DEACTIVATED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(2915L), ErrorLabels.E_SERVICE_DEACTIVATED),
    E_TABLE_NOT_FOUND(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3000L), ErrorLabels.E_TABLE_NOT_FOUND),
    E_TIMEOUT(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3001L), ErrorLabels.E_TIMEOUT),
    E_TYPE_MISMATCH(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3002L), ErrorLabels.E_TYPE_MISMATCH),
    E_UNDERFLOW(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3100L), ErrorLabels.E_UNDERFLOW),
    E_UNKNOWN(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3101L), ErrorLabels.E_UNKNOWN),
    E_UNSUPPORTED_ALGORITHM(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3102L), ErrorLabels.E_UNSUPPORTED_ALGORITHM),
    E_UNSUPPORTED_CODEC(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3103L), ErrorLabels.E_UNSUPPORTED_CODEC),
    E_UNSUPPORTED_FAMILY(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3104L), ErrorLabels.E_UNSUPPORTED_FAMILY),
    E_UNSUPPORTED_FORMAT(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3105L), ErrorLabels.E_UNSUPPORTED_FORMAT),
    E_UNSUPPORTED_PROTOCOL(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3106L), ErrorLabels.E_UNSUPPORTED_PROTOCOL),
    E_UNSUPPORTED_OPERATION(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3107L), ErrorLabels.E_UNSUPPORTED_OPERATION),
    E_UNSUPPORTED_OPTION(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3108L), ErrorLabels.E_UNSUPPORTED_OPTION),
    E_UNSUPPORTED_SERVICE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3109L), ErrorLabels.E_UNSUPPORTED_SERVICE),
    E_UNSUPPORTED_TYPE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3110L), ErrorLabels.E_UNSUPPORTED_TYPE),
    E_URL_CHANGED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3111L), ErrorLabels.E_URL_CHANGED),
    E_USER_AGENT_NOT_ALLOWED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3112L), ErrorLabels.E_USER_AGENT_NOT_ALLOWED),
    E_USER_ALREADY_REGISTERED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3113L), ErrorLabels.E_USER_ALREADY_REGISTERED),
    E_USER_NOT_FOUND(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3114L), ErrorLabels.E_USER_NOT_FOUND),
    E_USER_NOT_REGISTERED(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3115L), ErrorLabels.E_USER_NOT_REGISTERED),
    E_UNSUPPORTED_LANGUAGE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3116L), ErrorLabels.E_UNSUPPORTED_LANGUAGE),
    E_UNSUPPORTED_VERSION(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3117L), ErrorLabels.E_UNSUPPORTED_VERSION),
    E_UNSUPPORTED_LOCALE(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3118L), ErrorLabels.E_UNSUPPORTED_LOCALE),
    E_WOULD_BLOCK(DAErrorCode.getERR_SRC_FRAMEWORK() + DAErrorCode.SET_E_CAUSE(3300L), ErrorLabels.E_WOULD_BLOCK),
    GL_INVALID_ENUM(1280L, "An unacceptable value is specified for an enumerated argument. The offending command is ignored and has no other side effect than to set the error flag."),
    GL_INVALID_VALUE(1281L, "A numeric argument is out of range. The offending command is ignored and has no other side effect than to set the error flag."),
    GL_INVALID_OPERATION(1282L, "The specified operation is not allowed in the current state. The offending command is ignored and has no other side effect than to set the error flag."),
    GL_INVALID_MEMORY(1283L, "There is not enough memory left to execute the command. The state of the GL is undefined, except for the state of the error flags, after this error is recorded."),
    GL_INVALID_FRAMEBUFFER_OPERATION(1284L, "The command is trying to render to or read from the framebuffer while the currently bound framebuffer is not framebuffer complete (i.e. the return value from glCheckFramebufferStatus is not GL_FRAMEBUFFER_COMPLETE). The offending command is ignored and has no other side effect than to set the error flag.");

    private final long errno;
    private final String message;
    private static final int E_SEVERITY_POS = 31;
    private static final int E_TYPE_POS = 29;

    private DAErrorCode(long errno, String message) {
        this.errno = errno;
        this.message = message;
    }

    public long getErrno() {
        return this.errno;
    }

    public String getMessage() {
        return this.message;
    }

    private static long SET_E_SEVERITY(long x) {
        return DAErrorCode.PUT_MASK(0L, x, 31L);
    }

    private static long PUT_MASK(long var, long val, long pos) {
        return var | val << (int)pos;
    }

    private static long SET_E_TYPE(long x) {
        return DAErrorCode.PUT_MASK(0L, x, 29L);
    }

    private static long getE_FAILURE() {
        return DAErrorCode.SET_E_SEVERITY(1L);
    }

    private static long getERR_SRC_FRAMEWORK() {
        return DAErrorCode.SET_E_SEVERITY(1L) + DAErrorCode.SET_E_TYPE(1L);
    }

    private static long SET_E_CAUSE(long x) {
        return x;
    }
}

