/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.project.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class BinaryInfoDBTable
extends DBTable {
    public static final String TABLENAME = "BINARY_INFORMATION";
    private static final int MD5SUMSTRLENGTH = 64;

    public BinaryInfoDBTable() {
        this.addColumn(new DBColumn(COLUMN.BINARYID.name, "PRIMARY KEY", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.BINTYPE.name, "", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.TARGETPATH.name, "NOT NULL", "VARCHAR", 1024));
        this.addColumn(new DBColumn(COLUMN.LOCALPATH.name, "", "VARCHAR", 1024));
        this.addColumn(new DBColumn(COLUMN.MD5SUM.name, "", "VARCHAR", 64));
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(COLUMN.BINARYID.index + 1, (Integer)rowData.get(COLUMN.BINARYID.index));
                prep.setInt(COLUMN.BINTYPE.index + 1, (Integer)rowData.get(COLUMN.BINTYPE.index));
                String retstr = this.clipString((String)rowData.get(COLUMN.TARGETPATH.index), 1024, rowData.get(COLUMN.BINARYID.index).toString());
                prep.setString(COLUMN.TARGETPATH.index + 1, retstr);
                retstr = this.clipString((String)rowData.get(COLUMN.LOCALPATH.index), 1024, rowData.get(COLUMN.BINARYID.index).toString());
                prep.setString(COLUMN.LOCALPATH.index + 1, retstr);
                retstr = this.clipString((String)rowData.get(COLUMN.MD5SUM.index), 64, rowData.get(COLUMN.BINARYID.index).toString());
                prep.setString(COLUMN.MD5SUM.index + 1, retstr);
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getInt(1));
            row.add(rs.getInt(2));
            row.add(rs.getString(3));
            row.add(rs.getString(4));
            row.add(rs.getString(5));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        BINARYID(0, "BINARY_ID"),
        BINTYPE(1, "BINARY_TYPE"),
        TARGETPATH(2, "TARGET_PATH"),
        LOCALPATH(3, "LOCAL_PATH"),
        MD5SUM(4, "MD5SUM");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

